/**
 * fshows.com
 * Copyright (C) 2013-2025 All Rights Reserved.
 */
package com.fshows.postar.response.share.product.detail;

import lombok.Data;

import java.math.BigDecimal;

/**
 * 产品费用详情
 *
 * @author wangyi
 * @version CostProductDetailInfo.java, v 0.1 2025-12-10 wangyi
 */
@Data
public class CostProductDetailInfo {

    /**
     * 年费收取模式
     * 00-商户转账 01-线上模式
     */
    private String splitCostMode;

    /**
     * 年费项目版本
     */
    private String splitCostVersion;

    /**
     * 年费金额 元
     */
    private BigDecimal costAmt;

    /**
     * 接口费收取模式
     * 00-商户转账,01-线上模式
     */
    private String isvCostMode;

    /**
     * 接口费金额 元
     */
    private BigDecimal isvCostAmt;

    /**
     * 分账服务费%
     */
    private String fee;

    /**
     * D0分账服务费承担方
     */
    private String accFeeTypeD0;

    /**
     * D0分账服务费承担比例
     */
    private String accFeeRatioD0;

    /**
     * D1T1分账服务费承担方
     */
    private String accFeeTypeD1T1;

    /**
     * D1T1分账服务费承担比例%
     */
    private String accFeeRatioD1T1;

    /**
     * 是否特殊申请
     * 0否 1是
     */
    private Integer isSpecialApply;
}
