/**
 * fshows.com
 * Copyright (C) 2013-2025 All Rights Reserved.
 */
package com.fshows.postar.response.share.product.detail;

import lombok.Data;

/**
 * 产品基本信息详情
 *
 * @author wangyi
 * @version BasicProductDetailInfo.java, v 0.1 2025-12-10 wangyi
 */
@Data
public class BasicProductDetailInfo {

    /**
     * 产品id
     */
    private String productId;

    /**
     * 分账模式
     * 0-单商户 1-单归集
     */
    private Integer productType;

    /**
     * 管理方商户号
     */
    private String custId;

    /**
     * 分账通道
     * 0-国通备付金
     */
    private Integer splitChannel;

    /**
     * 商户方/归集方最大分账比例%
     */
    private String maxSplitRatio;

    /**
     * 分账地区城市id
     */
    private String cityId;

    /**
     * 分账地区区县id
     */
    private String areaId;

    /**
     * 分账地区省市id
     */
    private String provinceId;

    /**
     * 分账场景
     */
    private String accSplitSence;

    /**
     * 其他（分账场景）
     */
    private String accSplitSenceAdd;

    /**
     * 开通说明
     */
    private String note;
}
