/**
 * fshows.com
 * Copyright (C) 2013-2024 All Rights Reserved.
 */
package com.fshows.postar.request.trade;

import com.fshows.postar.request.PostarBaseReq;
import lombok.Data;

import javax.validation.constraints.NotBlank;

/**
 * 预授权完成撤销请求
 *
 * @author Cascade
 * @version PostarPreAuthFinishCancelReq.java, v 0.1 2025-12-08 14:50 Cascade
 */
@Data
public class PostarPreAuthFinishCancelReq extends PostarBaseReq {
    private static final long serialVersionUID = -7304928374923847234L;

    /**
     * 机构号
     * 商户所在国通系统内机构号（或虚拟机构号），场景应用可以填默认值：FWHHLD000000
     * (必填)
     */
    @NotBlank
    private String agetId;

    /**
     * 商户号
     * (必填)
     */
    @NotBlank
    private String custId;

    /**
     * 原第三方完成订单号
     * (选填)
     */
    private String oldThreeNo;

    /**
     * 第三方完成撤销订单号
     * (必填)
     */
    @NotBlank
    private String threeOrderNo;

    /**
     * 原国通平台单号
     * 对应支付接口返回的orderNo（原国通平台订单号，原三方单号二选一）
     * (选填)
     */
    private String reOrderNo;

    /**
     * 备注
     * (选填)
     */
    private String remark;

    /**
     * 验签
     * (必填)
     */
    @NotBlank
    private String sign;
}
