package com.fshows.postar.request.merchant;

import com.fshows.postar.request.PostarBaseReq;
import lombok.Data;

import javax.validation.constraints.NotBlank;

@Data
public class PostarUploadImageReq extends PostarBaseReq {

    /**
     * 操作类型: 1 - 新增, 2 - 修改 (若有商户号 custId 请填写 2)
     * 必填: 是
     */
    @NotBlank
    private String operType;

    /**
     * 商户手机号
     * 必填: 是
     */
    @NotBlank
    private String custLogin;

    /**
     * 600商户号
     * 在有商户号的情况下必须要传
     * 必填: 否
     */
    private String custId;

    /**
     * 图片时间戳
     * 商户的第一张图片，无需上传该字段，由国通服务端返回。
     * 同一商户其他图片上传时，需带上第一张图片返回的时间戳，
     * 国通系统将进行合并，后续用于基础进件时上传。
     * 对应进件接口字段“时间戳（timestamp）”。
     * 【注：一旦商户生成第一个时间戳建议记录，
     * 可用于后续商户修改图片信息使用，一旦时间戳信息变更，
     * 商户所有图片需重新上传，后端使用时间戳查询商户图片】
     * 必填: 否
     */
    private String timestamp;

    /**
     * 上传图片标识
     * 1：身份证正面照片
     * 2：身份证反面照片
     * 3：对公上传“开户许可证/印鉴卡”
     * 4：营业场所门头照
     * 5：营业场所内景照
     * 6：补充材料①
     * 7：补充材料②
     * 8：补充资料③（手持结算卡照片）
     * 9：事业单位证明函照片
     * 10：补充材料⑤
     * 12：营业执照
     * 13：非法人对私身份证正面照
     * 14：非法人对私身份证反面照
     * 15：非法人对私上传的授权书
     * 16：结算人站门头照（储备字段无需处理）
     * 17：非法人授权结算书合影
     * 18：收银台照
     * 19：结算人收银台照
     * 20：入网协议照①
     * 21：入网协议照②
     * 22：入网协议照③
     * 23：入网协议照④
     * 24：入网协议照⑤
     * 25：入网协议照⑥
     * 26：入网协议照⑦
     * 27：入网协议照⑧
     * 28：入网协议照⑨
     * 29：入网协议照⑩
     * 35：入网协议照⑪
     * 必填: 是
     */
    @NotBlank
    private String flag;

    /**
     * 营业执照，flag为12时必传，企业与个体户传营业执照，
     * 政府组织及事业单位传事业单位法人证书、其他组织机构传登记证书
     */
    private String busPhotoFront;

    /**
     * 事业单位证明函照片，flag为9时必传，政府组织及事业单位必传，
     * 可在材料下载板块-单位证明涵接口下载模板
     */
    private String filed4;

    /**
     * 身份证正面照，flag为1时必传
     */
    private String credPhotoFront;

    /**
     * 身份证反面照，flag为2时必传
     */
    private String credPhotoBack;

    /**
     * 结算卡正面照，flag为3时必传（法人对私与非法人对私上传“结算卡正面照”，对公上传“开户许可证/印鉴卡”）
     */
    private String authPic;

    /**
     * 非法人对私身份证正面照，flag为13时必传，结算类型为非法人时必传
     */
    private String credPicF;

    /**
     * 非法人对私身份证反面照，flag为14时必传，结算类型为非法人时必传
     */
    private String credPicB;

    /**
     * 非法人授权结算书合影，flag为17时必传，结算类型为非法人时必传（法人或结算人与授权书合影）
     */
    private String stlAuth;

    /**
     * 非法人对私上传的授权书。
     * flag为15时必传，结算类型为非法人时必传，可在材料下载板块内下载。
     */
    private String authCert;

    /**
     * 结算人站门头照。
     * 储备字段（无需处理）。
     */
    private String stlDoor;

    /**
     * 结算人站收银台照。
     * flag为19时必传，小微商户必传。
     */
    private String jsrcPhoto;

    /**
     * 经营场所内景照。
     * flag为5时必传，所有进件商户类型都需传。
     */
    private String indoorScenesPhoto;

    /**
     * 经营场所门头照。
     * flag为4时必传，所有进件商户类型都需传。
     */
    private String doorHeaderPhoto;

    /**
     * 收银台照。
     * flag为18时必传，所有进件商户类型都需传。
     */
    private String cashierPhoto;

    /**
     * 补充材料5。
     * 非必传。
     */
    private String filed5;

    /**
     * 补充资料3。
     * 非必传。
     */
    private String filed3;

    /**
     * 补充材料2。
     * 非必传。
     */
    private String filed2;

    /**
     * 补充材料1。
     * 非必传。
     */
    private String filed1;

    /**
     * 入网协议照1。
     * flag为20时必传，未进行安心签时需上传。
     */
    private String infoPhoto1;

    /**
     * 入网协议照2。
     * flag为21时必传，未进行安心签时需上传。
     */
    private String infoPhoto2;

    /**
     * 入网协议照3。
     * flag为22时必传，未进行安心签时需上传。
     */
    private String infoPhoto3;

    /**
     * 入网协议照4。
     * flag为23时必传，未进行安心签时需上传。
     */
    private String netPhoto1;

    /**
     * 入网协议照5。
     * flag为24时必传，未进行安心签时需上传。
     */
    private String netPhoto2;


    /**
     * 入网协议照6。
     * flag为25时必传，未进行安心签时需上传。
     */
    private String netPhoto3;

    /**
     * 入网协议照7。
     * flag为26时必传，未进行安心签时需上传。
     */
    private String netPhoto4;

    /**
     * 入网协议照8。
     * flag为27时必传，未进行安心签时需上传。
     */
    private String netPhoto5;

    /**
     * 入网协议照9。
     * flag为28时必传，未进行安心签时需上传。
     */
    private String netPhoto6;

    /**
     * 入网协议照10。
     * flag为29时必传，未进行安心签时需上传。
     */
    private String netPhoto7;

    /**
     * 入网协议照11。
     * flag为35时必传，未进行安心签时需上传。
     */
    private String netPhoto8;
}