package com.fshows.postar.apienum;

import com.fshows.postar.contant.PostarConstant;
import com.fshows.postar.enums.ApiRequestTypeEnum;
import com.fshows.postar.request.merchant.*;
import com.fshows.postar.response.merchant.*;
import com.fshows.sdk.core.client.base.definition.IApiDefinition;

/**
 * 国通星驿商户相关API
 *
 * @author zhaoxumin
 * @version PostarMerchantApiEnum.java, v 0.1 2024-06-13 15:25:59 zhaoxumin
 */
public enum PostarMerchantApiEnum implements IApiDefinition {
    CUST_CONFIG(
            "指定渠道报备",
            "/yyfsevr/custConfig/config",
            PostarConstant.DEFAULT_API_VERSION,
            PostarCustConfigReq.class,
            PostarCustConfigRes.class,
            ApiRequestTypeEnum.POST
    ),
    WX_PAY_CONFIG(
            "配置微信支付目录",
            "/yyfsevr/addCust/wxPayConfig",
            PostarConstant.DEFAULT_API_VERSION,
            PostarWxPayConfigReq.class,
            PostarWxPayConfigRes.class,
            ApiRequestTypeEnum.POST
    ),
    APPID_CONFIG(
            "微信APPID配置",
            "/yyfsevr/addCust/appidConfig",
            PostarConstant.DEFAULT_API_VERSION,
            PostarAppidConfigReq.class,
            PostarAppidConfigRes.class,
            ApiRequestTypeEnum.POST
    ),
    UPLOAD_IMAGE(
            "商户进件上传图片",
            "/yyfsevr/addCust/uploadImg",
            PostarConstant.DEFAULT_API_VERSION,
            PostarUploadImageReq.class,
            PostarUploadImageRes.class,
            ApiRequestTypeEnum.POST
    ),
    AUDIT_QUERY(
            "审核结果查询",
            "/yyfsevr/addCust/getResult",
            PostarConstant.DEFAULT_API_VERSION,
            PostarAuditQueryReq.class,
            PostarAuditQueryRes.class,
            ApiRequestTypeEnum.GET
    ),
    MINI_OPEN_APPLICATION(
            "小微商户申请/驳回重新申请",
            "/yyfsevr/addCust/miniApply",
            PostarConstant.DEFAULT_API_VERSION,
            PostarMiniOpenApplicationReq.class,
            PostarMiniOpenApplicationRes.class,
            ApiRequestTypeEnum.POST
    ),
    MINI_CHANGE(
            "小微商户修改",
            "/yyfsevr/addCust/updateMini",
            PostarConstant.DEFAULT_API_VERSION,
            PostarMiniChangeReq.class,
            PostarMiniChangeRes.class,
            ApiRequestTypeEnum.POST
    ),
    COMMON_OPEN_APPLICATION(
            "普通商户申请/驳回重新申请",
            "/yyfsevr/addCust/commonApply",
            PostarConstant.DEFAULT_API_VERSION,
            PostarCommonOpenApplicationReq.class,
            PostarCommonOpenApplicationRes.class,
            ApiRequestTypeEnum.POST
    ),
    COMMON_CHANGE(
            "普通商户修改",
            "/yyfsevr/addCust/updateCommon",
            PostarConstant.DEFAULT_API_VERSION,
            PostarCommonChangeReq.class,
            PostarCommonChangeRes.class,
            ApiRequestTypeEnum.POST
    ),
    MERCHANT_QUERY(
            "获取商户信息",
            "/yyfsevr/addCust/getCustInfo",
            PostarConstant.DEFAULT_API_VERSION,
            PostarMerchantQueryReq.class,
            PostarMerchantQueryRes.class,
            ApiRequestTypeEnum.GET
    ),
    PROVINCE_QUERY(
            "获取省",
            "/yyfsevr/addCust/getProvince",
            PostarConstant.DEFAULT_API_VERSION,
            PostarProvinceQueryReq.class,
            PostarProvinceQueryRes.class,
            ApiRequestTypeEnum.GET
    ),
    REPORT_QUERY(
            "查询报备信息",
            "/yyfsevr/addCust/getReportInfo",
            PostarConstant.DEFAULT_API_VERSION,
            PostarReportQueryReq.class,
            PostarReportQueryRes.class,
            ApiRequestTypeEnum.POST
    ),
    ANXIN_SIGN_PERSON(
            "安心签个人用户开户",
            "/yyfsevr/anxinsign/person",
            PostarConstant.DEFAULT_API_VERSION,
            PostarAnxinSignPersonReq.class,
            PostarAnxinSignPersonRes.class,
            ApiRequestTypeEnum.POST
    ),
    ANXIN_SIGN_SEND_CODE(
            "安心签发短信验证码",
            "/yyfsevr/anxinsign/sendCode",
            PostarConstant.DEFAULT_API_VERSION,
            PostarAnxinSignSendCodeReq.class,
            PostarAnxinSignSendCodeRes.class,
            ApiRequestTypeEnum.POST
    ),
    ANXIN_SIGN_SUPPLEMENTARY(
            "安心签补签",
            "/yyfsevr/anxinsign/supplementary",
            PostarConstant.DEFAULT_API_VERSION,
            PostarAnxinSignSupplementaryReq.class,
            PostarAnxinSignSupplementaryRes.class,
            ApiRequestTypeEnum.POST
    ),
    ANXIN_SIGN_COMPANY(
            "安心签企业用户开户",
            "/yyfsevr/anxinsign/company",
            PostarConstant.DEFAULT_API_VERSION,
            PostarAnxinSignCompanyReq.class,
            PostarAnxinSignCompanyRes.class,
            ApiRequestTypeEnum.POST
    ),
    UPDATE_CUST_ACCOUNT(
            "修改结算卡",
            "/yyfsevr/addCust/updateCustAccount",
            PostarConstant.DEFAULT_API_VERSION,
            PostarUpdateCustAccountReq.class,
            PostarUpdateCustAccountRes.class,
            ApiRequestTypeEnum.POST
    ),
    UPDATE_CUST_RATE(
            "修改商户费率",
            "/yyfsevr/addCust/updateCustRate",
            PostarConstant.DEFAULT_API_VERSION,
            PostarUpdateCustRateReq.class,
            PostarUpdateCustRateRes.class,
            ApiRequestTypeEnum.POST
    ),
    QUERY_BANK_INFO_BY_CARD(
            "根据银行卡号获取银行信息",
            "/yyfsevr/addCust/queryInfoByCard",
            PostarConstant.DEFAULT_API_VERSION,
            PostarQueryBankInfoByCardReq.class,
            PostarQueryBankInfoByCardRes.class,
            ApiRequestTypeEnum.GET
    ),
    APPLY_MERCHANT_SETTLEMENT(
            "结算业务申请",
            "/yyfsevr/addCust/applyStlmt",
            PostarConstant.DEFAULT_API_VERSION,
            PostarApplyMerchantSettlementReq.class,
            PostarApplyMerchantSettlementRes.class,
            ApiRequestTypeEnum.POST
    ),
    UPDATE_MERCHANT_SETTLEMENT(
            "结算业务变更",
            "/yyfsevr/addCust/updateStlmt",
            PostarConstant.DEFAULT_API_VERSION,
            PostarUpdateMerchantSettlementReq.class,
            PostarUpdateMerchantSettlementRes.class,
            ApiRequestTypeEnum.POST
    ),
    QUERY_MERCHANT_SETTLEMENT(
            "结算业务状态查询",
            "/yyfsevr/addCust/queryStlmt",
            PostarConstant.DEFAULT_API_VERSION,
            PostarQueryMerchantSettlementReq.class,
            PostarQueryMerchantSettlementRes.class,
            ApiRequestTypeEnum.POST
    ),

    /**
     * 设备绑定
     */
    BIND_POS(
            "设备绑定",
            "/yyfsevr/device/bindPos",
            PostarConstant.DEFAULT_API_VERSION,
            PostarBindPosReq.class,
            PostarBindPosRes.class,
            ApiRequestTypeEnum.POST
    ),

    /**
     * 设备解绑
     */
    UNBIND_POS(
            "设备解绑",
            "/yyfsevr/device/unBindPos",
            PostarConstant.DEFAULT_API_VERSION,
            PostarUnbindPosReq.class,
            PostarUnbindPosRes.class,
            ApiRequestTypeEnum.POST
    ),

    /**
     * 收款设备绑定查询
     */
    BINDING_SYNCHRONIZATION(
            "收款设备绑定查询",
            "/yyfsevr/cardEquipment/bindingSynchronization",
            PostarConstant.DEFAULT_API_VERSION,
            PostarBindingSynchronizationReq.class,
            PostarBindingSynchronizationRes.class,
            ApiRequestTypeEnum.POST
    )
    ;

    /**
     * 接口名称
     */
    private String name;
    /**
     * 接口uri子资源路径
     */
    private String apiSubURI;
    /**
     * 接口版本，默认1.0
     */
    private String version;
    /**
     * 请求业务参数的Class类型
     */
    private Class requestClass;
    /**
     * 响应业务参数的Class类型
     */
    private Class responseClass;
    /**
     * 请求类型
     */
    private ApiRequestTypeEnum apiRequestType;


    PostarMerchantApiEnum(String name,
                          String apiSubURI,
                          String version,
                          Class requestClass,
                          Class responseClass,
                          ApiRequestTypeEnum ApiRequestTypeEnum) {
        this.name = name;
        this.apiSubURI = apiSubURI;
        this.version = version;
        this.requestClass = requestClass;
        this.responseClass = responseClass;
        this.apiRequestType = ApiRequestTypeEnum;
    }

    @Override
    public String getApiURI() {
        return apiSubURI;
    }


    @Override
    public String getVersion() {
        return version;
    }

    @Override
    public Class getRequestClass() {
        return requestClass;
    }

    @Override
    public Class getResponseClass() {
        return responseClass;
    }

    public ApiRequestTypeEnum getApiRequestType() {
        return apiRequestType;
    }
}