/*
 * Decompiled with CFR 0.152.
 */
package com.fshows.postar;

import cn.hutool.core.collection.CollUtil;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.fshows.postar.apienum.PostarBankActivityApiEnum;
import com.fshows.postar.request.PostarBaseReq;
import com.fshows.postar.response.PostarBizRes;
import com.fshows.postar.util.SignUtil;
import com.fshows.sdk.core.client.base.AbstractApiClient;
import com.fshows.sdk.core.client.base.handler.IHttpRequestHandler;
import com.fshows.sdk.core.client.base.handler.ISerializableHandler;
import com.fshows.sdk.core.client.base.model.ApiRequestModel;
import com.fshows.sdk.core.client.base.model.ApiResponseModel;
import com.fshows.sdk.core.client.base.model.ClientInfoModel;
import com.fshows.sdk.core.client.base.model.DefaultClientConfigModel;
import com.fshows.sdk.core.client.base.model.DefaultRequestContext;
import com.fshows.sdk.core.client.component.http.PostHttpRequestHandler;
import com.fshows.sdk.core.client.component.serializable.JsonSerializableHandler;
import com.fshows.sdk.core.exception.FsApiException;
import com.fshows.sdk.core.util.LogUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PostarBankActivityApiClient
extends AbstractApiClient<PostarBaseReq, PostarBizRes, PostarBankActivityApiEnum> {
    private static final Logger log = LoggerFactory.getLogger(PostarBankActivityApiClient.class);
    protected ISerializableHandler paramSerializable = new JsonSerializableHandler();
    protected IHttpRequestHandler httpRequestHandler = new PostHttpRequestHandler();

    public PostarBankActivityApiClient(DefaultClientConfigModel apiClientConfig) throws FsApiException {
        super(apiClientConfig);
    }

    protected PostarBizRes doExecute(PostarBaseReq request, PostarBankActivityApiEnum iApiDefinition, DefaultClientConfigModel merchantConfigModel) throws FsApiException {
        long beginTime = System.currentTimeMillis();
        LogUtil.info((Logger)log, (String)"{} >> \u6267\u884c\u8bf7\u6c42\u5f00\u59cb >> iApiDefinition={}, request={}", (Object[])new Object[]{this.getClientInfo().getClientDesc(), iApiDefinition, request});
        DefaultRequestContext requestContext = this.buildRequestContext(iApiDefinition, request, merchantConfigModel);
        ApiRequestModel apiRequestModel = null;
        ApiResponseModel apiResponseModel = null;
        try {
            this.checkParam(request, requestContext);
            apiRequestModel = this.buildApiRequestModel(request, requestContext);
            apiResponseModel = this.httpRequest(apiRequestModel, requestContext);
            Object requestBody = ObjectUtils.defaultIfNull((Object)apiRequestModel.getRequestBody(), (Object)apiRequestModel.getRequestForm());
            LogUtil.info((Logger)log, (String)"{} >> \u8bf7\u6c42\u7ed3\u675f >> url={}, method={}, request={}, response={}, cost={}ms", (Object[])new Object[]{requestContext.getClientInfoModel().getClientDesc(), apiRequestModel.getApiURL(), iApiDefinition, requestBody, apiResponseModel.getResponseBody(), System.currentTimeMillis() - beginTime});
            return this.buildApiResponse(apiResponseModel, apiRequestModel, requestContext);
        }
        catch (FsApiException e) {
            LogUtil.error((Logger)log, (String)"{} >> \u8bf7\u6c42\u5f02\u5e38 >> apiDefinition={}, bizRequest={}, apiRequestModel={}, apiResponseModel={}", (Throwable)e, (Object[])new Object[]{requestContext.getClientInfoModel().getClientDesc(), iApiDefinition, request, apiRequestModel, apiResponseModel});
            throw e;
        }
        catch (Exception e) {
            LogUtil.error((Logger)log, (String)"{} >> \u8bf7\u6c42\u5f02\u5e38 >> apiDefinition={}, bizRequest={}, apiRequestModel={}, apiResponseModel={}", (Throwable)e, (Object[])new Object[]{requestContext.getClientInfoModel().getClientDesc(), iApiDefinition, request, apiRequestModel, apiResponseModel});
            throw new FsApiException(e.getMessage(), (Throwable)e);
        }
    }

    protected ApiRequestModel buildApiRequestModel(PostarBaseReq request, DefaultRequestContext context) {
        String requestBody = "";
        try {
            ApiRequestModel apiRequestModel = new ApiRequestModel();
            apiRequestModel.setApiURL(context.getApiClientConfig().getApiParentURL() + context.getIApiDefinition().getApiURI());
            JSONObject bodyJson = (JSONObject)JSONObject.toJSON((Object)request);
            bodyJson.put("agetId", (Object)context.getApiClientConfig().getAppId());
            bodyJson.put("version", (Object)context.getIApiDefinition().getVersion());
            ArrayList params = new ArrayList(bodyJson.size());
            bodyJson.forEach((s, o) -> {
                if (o != null) {
                    params.add(s + "=" + o);
                }
            });
            Collections.sort(params);
            String sign = SignUtil.encrypt(this.apiClientConfig.getPayCompanyPublicKey(), SignUtil.getSHA256(StringUtils.join(params, (String)"&")));
            bodyJson.put("sign", (Object)sign);
            apiRequestModel.setRequestBody(JSONObject.toJSONString((Object)bodyJson));
            HashMap<String, String> headMap = new HashMap<String, String>();
            headMap.put("Accept-Encoding", "identity");
            apiRequestModel.setHeadMap(headMap);
            return apiRequestModel;
        }
        catch (Exception e) {
            LogUtil.error((Logger)log, (String)"{} >> \u8bf7\u6c42\u56fd\u901a\u661f\u9a7f\u5f02\u5e38 >> iApiDefinition={}, request={}, requestBody={}", (Throwable)e, (Object[])new Object[]{this.getClientInfo().getClientDesc(), context.getIApiDefinition(), request, requestBody});
            throw new RuntimeException(e);
        }
    }

    protected ClientInfoModel getClientInfo() {
        ClientInfoModel clientInfoModel = new ClientInfoModel();
        clientInfoModel.setClientCode("postar-sdk");
        clientInfoModel.setClientName("\u56fd\u901a\u661f\u9a7f");
        return clientInfoModel;
    }

    protected PostarBizRes buildApiResponse(ApiResponseModel apiResponseModel, ApiRequestModel apiRequestModel, DefaultRequestContext requestContext) {
        JSONObject dataJson = new JSONObject();
        try {
            String responseBody = apiResponseModel.getResponseBody();
            JSONObject resJson = JSONObject.parseObject((String)responseBody);
            JSONArray data = resJson.getJSONArray("data");
            if (Objects.nonNull(data) && CollUtil.isNotEmpty((Collection)data)) {
                dataJson.put("list", (Object)data);
            }
            resJson.remove((Object)"data");
            dataJson.putAll((Map)resJson);
            return (PostarBizRes)JSONObject.parseObject((String)dataJson.toJSONString(), (Class)requestContext.getIApiDefinition().getResponseClass());
        }
        catch (Exception e) {
            LogUtil.error((Logger)log, (String)"{} >> \u56fd\u901a\u661f\u9a7f\u54cd\u5e94\u5f02\u5e38 >> iApiDefinition={}, request={}, \u4e1a\u52a1\u54cd\u5e94\u62a5\u6587dataJson={}", (Throwable)e, (Object[])new Object[]{this.getClientInfo().getClientDesc(), requestContext.getIApiDefinition(), apiRequestModel.getRequest(), dataJson});
            throw new RuntimeException(e);
        }
    }

    protected ApiResponseModel httpRequest(ApiRequestModel apiRequestModel, DefaultRequestContext requestContext) throws IOException {
        return this.httpRequestHandler.httpRequest(apiRequestModel, requestContext);
    }

    public PostarBizRes execute(PostarBaseReq request, PostarBankActivityApiEnum apiDefinition) throws FsApiException {
        return (PostarBizRes)this.doExecute(request, apiDefinition);
    }

    public PostarBizRes execute(PostarBaseReq request, PostarBankActivityApiEnum apiDefinition, DefaultClientConfigModel configModel) throws FsApiException {
        return this.doExecute(request, apiDefinition, configModel);
    }
}

