/**
 * fshows.com
 * Copyright (C) 2013-2024 All Rights Reserved.
 */
package com.fshows.postar.response.trade;

import com.alibaba.fastjson.annotation.JSONField;
import com.fshows.postar.response.PostarBizRes;
import lombok.Data;

/**
 * @author wangqilei
 * @version PostarOrderPayRes.java, v 0.1 2024-06-05 3:55 PM wangqilei
 */
@Data
public class PostarJsApiPayCreateRes extends PostarBizRes {

    private static final long serialVersionUID = 9095435038373818460L;

    /**
     * 可支付标识（微信支付、银联返回）
     * 为1时为可支付，其它表示交易未知
     * (选填)
     */
    private String getPrepayId;

    /**
     * 微信预支付ID
     * 根据返回ID调用官方接口唤起支付框
     * (选填)
     */
    private String prePayId;

    /**
     * 银联预支付ID
     * 根据返回ID调用官方接口唤起支付框
     * (选填)
     */
    @JSONField(name = "prePayid")
    private String unionPrePayId;

    /**
     * 支付宝可支付标识
     * 为1时为可支付，其它表示交易未知
     * (选填)
     */
    @JSONField(name = "getprepayid")
    private String alipayGetPrepayId;

    /**
     * 支付宝预支付ID
     * 根据返回ID调用官方接口唤起支付框
     * (选填)
     */
    @JSONField(name = "prepayid")
    private String alipayPrePayId;

    /**
     * appid(微信支付)
     * (必填)
     */
    private String jsapiAppid;

    /**
     * 时间戳（微信支付）
     * (必填)
     */
    private String jsapiTimestamp;

    /**
     * 随机字符串（微信支付）
     * (必填)
     */
    private String jsapiNoncestr;

    /**
     * 微信支付的JSAPI包名
     * (必填)
     */
    private String jsapiPackage;

    /**
     * 签名类型（微信支付）
     * (必填)
     */
    private String jsapiSignType;

    /**
     * jsapiPaySign（微信支付）
     * (必填)
     */
    private String jsapiPaySign;

    /**
     * 第三方订单号，商户单号
     * 合作方订单号
     * (必填)
     */
    private String threeOrderNo;

    /**
     * 机构编号
     * (必填)
     */
    private String agetId;

    /**
     * 国通平台订单号
     * 可用于退款
     * (必填)
     */
    private String orderNo;

    /**
     * 交易时间
     * (必填)
     */
    private String orderTime;

    /**
     * 银联返回重定向地址
     * (特殊必填)
     */
    private String redirecturl;

    /**
     * 可支付标识（支付宝支付返回）
     * 为1时为可支付，其它表示交易未知
     * (选填)
     */
    private String getprepayid;

    /**
     * 预支付ID（银联支付返回）
     */
    private String prePayid;
}