/**
 * fshows.com
 * Copyright (C) 2013-2025 All Rights Reserved.
 */
package com.fshows.postar.request.share.withdraw;

import com.fshows.postar.request.PostarBaseReq;
import lombok.Data;

import javax.validation.constraints.NotBlank;

/**
 * 提现-客户(XZY034)请求
 *
 * @author wangyi
 * @version PostarCustomerWithdrawReq.java, v 0.1 2025-12-10 wangyi
 */
@Data
public class PostarCustomerWithdrawReq extends PostarBaseReq {

    /**
     * 分账功能管理员商户的600商户号
     * 必填: 是
     */
    @NotBlank
    private String mainCustId;

    /**
     * 600商户号，商户号600和客户号二选一必选上送
     * 必填: 否
     */
    private String custId;

    /**
     * 客户编号。商户号600和客户号二选一必选上送
     * 必填: 否
     */
    private String customerId;

    /**
     * 备注
     * 必填: 是
     */
    @NotBlank
    private String remark;

    /**
     * 三方订单号
     * 必填: 是
     */
    @NotBlank
    private String otherOrderNo;

    /**
     * 结算卡号
     * 必填: 是
     */
    @NotBlank
    private String cardNo;

    /**
     * 提现金额：元
     * 必填: 是
     */
    @NotBlank
    private String withdrawalAmt;
}
