/**
 * fshows.com
 * Copyright (C) 2013-2025 All Rights Reserved.
 */
package com.fshows.postar.request.share.split;

import com.fshows.postar.request.PostarBaseReq;
import lombok.Data;

import javax.validation.constraints.NotBlank;

/**
 * 分账撤销退回(XZY017)请求
 *
 * @author wangyi
 * @version PostarSplitRevokeReq.java, v 0.1 2025-12-10 wangyi
 */
@Data
public class PostarSplitRevokeReq extends PostarBaseReq {

    /**
     * 原分账三方订单号
     * 必填: 否
     */
    private String oriOtherOrderNo;

    /**
     * 原分账子流水号
     * 必填: 否
     */
    private String tradeId;

    /**
     * 撤销/退回类型
     * 0-撤销【仅支持当天未结算的分账订单撤销到600未转结余额】
     * 1-退回【退回仅支持余额分账退回到出账方可用余额】
     * 必填: 是
     */
    @NotBlank
    private String revokeType;

    /**
     * 原订单交易时间
     * 格式:yyyymmdd，半年内可不传
     * 必填: 否
     */
    private String tradeTime;
}
