/**
 * fshows.com
 * Copyright (C) 2013-2025 All Rights Reserved.
 */
package com.fshows.postar.request.share.customer.detail;

import lombok.Data;

/**
 * 批量签约客户基础信息
 *
 * @author wangyi
 * @version BatchCustomerBaseInfo.java, v 0.1 2025-12-10 wangyi
 */
@Data
public class BatchCustomerBaseInfo {

    /**
     * 商户id
     * 选择600商户在星驿付的唯一代码,作为接收方新增客户
     * 必填: 是
     */
    private String custId;

    /**
     * 最大分账比例
     * 单位%，例如送1就是1%
     * 必填: 是
     */
    private String maxValue;

    /**
     * 标签
     * 必填: 否
     */
    private String tags;

    /**
     * 是否合并入账
     * 0-否 1-是，默认否，选择是的话，当天分账需结算订单，待第二天凌晨发起一笔结算提现
     * 必填: 是
     */
    private String isMergeWithDraw;
}
