/**
 * fshows.com
 * Copyright (C) 2013-2025 All Rights Reserved.
 */
package com.fshows.postar.request.share.collect.detail;

import lombok.Data;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.math.BigDecimal;

/**
 * 归集明细
 *
 * @author wangyi
 * @version AcntCollectDetail.java, v 0.1 2025-12-10 wangyi
 */
@Data
public class AcntCollectDetail {

    /**
     * 归集出款方商户号，600商户在星驿付的唯一代码
     * 必填: 是
     */
    @NotBlank
    private String outCustId;

    /**
     * 归集收款方商户号，600商户在星驿付的唯一代码
     * 必填: 否
     */
    private String inCustId;

    /**
     * 归集收款方客户号
     * 必填: 否
     */
    private String inCustomerId;

    /**
     * 归集金额：元
     * 必填: 是
     */
    @NotNull
    private BigDecimal txAmt;

    /**
     * 归集手续费自定义，不传按开通时候配置计算
     * 必填: 否
     */
    private String fee;

    /**
     * 出款方承担手续费比例%
     * 必填: 是
     */
    @NotNull
    private BigDecimal feeOutRatio;

    /**
     * 接收方承担手续费比例%
     * 必填: 是
     */
    @NotNull
    private BigDecimal feeInRatio;

    /**
     * 结算状态
     * 0-使用默认卡结算 1-指定结算卡结算 2-不结算，默认不结算
     * 必填: 否
     */
    private String settleStatus;

    /**
     * 接收方结算卡，有传就结算至接收方卡
     * 必填: 否
     */
    private String cardNo;

    /**
     * 结算附言
     * 必填: 否
     */
    private String tradeMemo;
}
