/**
 * fshows.com
 * Copyright (C) 2013-2025 All Rights Reserved.
 */
package com.fshows.postar.request.share.collect;

import com.fshows.postar.request.PostarBaseReq;
import lombok.Data;

import javax.validation.constraints.NotBlank;

/**
 * 归集余额查询接口(XZY042)请求
 *
 * @author wangyi
 * @version PostarCollectAcntQueryReq.java, v 0.1 2025-12-10 wangyi
 */
@Data
public class PostarCollectAcntQueryReq extends PostarBaseReq {

    /**
     * 归集功能管理员商户的600商户号
     * 必填: 是
     */
    @NotBlank
    private String mainCustId;

    /**
     * 600商户号
     * 商户号、客户号二选一
     * 必填: 否
     */
    private String custId;

    /**
     * 客户号
     * 商户号、客户号二选一
     * 必填: 否
     */
    private String customerId;
}
