package com.fshows.postar.apienum;

import com.fshows.postar.contant.PostarConstant;
import com.fshows.postar.request.trade.PostarCloseOrderReq;
import com.fshows.postar.request.trade.PostarGetCodeUrlReq;
import com.fshows.postar.request.trade.PostarJsApiPayCreateReq;
import com.fshows.postar.request.trade.PostarOrderQueryReq;
import com.fshows.postar.request.trade.PostarPreAuthCancelReq;
import com.fshows.postar.request.trade.PostarRefundCreateReq;
import com.fshows.postar.request.trade.PostarRefundQueryReq;
import com.fshows.postar.request.trade.PostarScanCardCreateReq;
import com.fshows.postar.request.trade.PostarUnionUserIdReq;
import com.fshows.postar.request.trade.PostarWxOpenIdReq;
import com.fshows.postar.response.trade.PostarCloseOrderRes;
import com.fshows.postar.response.trade.PostarGetCodeUrlRes;
import com.fshows.postar.response.trade.PostarJsApiPayCreateRes;
import com.fshows.postar.response.trade.PostarOrderQueryRes;
import com.fshows.postar.response.trade.PostarPreAuthCancelRes;
import com.fshows.postar.response.trade.PostarRefundCreateRes;
import com.fshows.postar.response.trade.PostarRefundQueryRes;
import com.fshows.postar.response.trade.PostarScanCardCreateRes;
import com.fshows.postar.response.trade.PostarUnionUserIdRes;
import com.fshows.postar.response.trade.PostarWxOpenIdRes;
import com.fshows.sdk.core.client.base.definition.IApiDefinition;

/**
 * 国通星驿交易相关API
 *
 * @author liluqing
 * @version PostarTradeApiEnum.java, v 0.1 2022-03-01 21:53 liluqing
 */
public enum PostarTradeApiEnum implements IApiDefinition {
    SCAN_CARD_CREATE(
            "商户主扫（B扫C）",
            "/yyfsevr/order/scanByMerchant",
            PostarConstant.DEFAULT_API_VERSION,
            PostarScanCardCreateReq.class,
            PostarScanCardCreateRes.class
    ),
    JS_API_PAY(
            "统一下单接口（C扫B）",
            "/yyfsevr/order/pay",
            PostarConstant.DEFAULT_API_VERSION,
            PostarJsApiPayCreateReq.class,
            PostarJsApiPayCreateRes.class
    ),
    ORDER_QUERY(
            "订单查询接口",
            "/yyfsevr/order/orderQuery",
            PostarConstant.DEFAULT_API_VERSION,
            PostarOrderQueryReq.class,
            PostarOrderQueryRes.class
    ),
    CLOSE_PAY(
            "扫码交易撤单/关单",
            "/yyfsevr/order/closePay",
            PostarConstant.DEFAULT_API_VERSION,
            PostarCloseOrderReq.class,
            PostarCloseOrderRes.class
    ),
    REFUND_CREATE(
            "退款申请发起",
            "/yyfsevr/order/refund",
            PostarConstant.DEFAULT_API_VERSION,
            PostarRefundCreateReq.class,
            PostarRefundCreateRes.class
    ),
    REFUND_QUERY(
            "退款查询接口",
            "/yyfsevr/order/refundQuery",
            PostarConstant.DEFAULT_API_VERSION,
            PostarRefundQueryReq.class,
            PostarRefundQueryRes.class
    ),
    UNIOU_USER_ID_QUERY(
            "获取银联userId",
            "/yyfsevr/order/getPaypalTag",
            PostarConstant.DEFAULT_API_VERSION,
            PostarUnionUserIdReq.class,
            PostarUnionUserIdRes.class
    ),
    GET_CODE_URL(
            "聚合码申请",
            "/yyfsevr/order/getCodeUrl",
            PostarConstant.DEFAULT_API_VERSION,
            PostarGetCodeUrlReq.class,
            PostarGetCodeUrlRes.class
    ),
    WX_OPENID_QUERY(
            "获取微信openId",
            "/yyfsevr/order/openid",
            PostarConstant.DEFAULT_API_VERSION,
            PostarWxOpenIdReq.class,
            PostarWxOpenIdRes.class
    ),
    PRE_AUTH_CANCEL(
            "预授权撤销",
            "/yyfsevr/trans/card/preAuthCancel",
            PostarConstant.DEFAULT_API_VERSION,
            PostarPreAuthCancelReq.class,
            PostarPreAuthCancelRes.class
    ),
    ;

    /**
     * 接口名称
     */
    private String name;
    /**
     * 接口uri子资源路径
     */
    private String apiSubURI;
    /**
     * 接口版本，默认1.0
     */
    private String version;
    /**
     * 请求业务参数的Class类型
     */
    private Class requestClass;
    /**
     * 响应业务参数的Class类型
     */
    private Class responseClass;


    PostarTradeApiEnum(String name,
                       String apiSubURI,
                       String version,
                       Class requestClass,
                       Class responseClass) {
        this.name = name;
        this.apiSubURI = apiSubURI;
        this.version = version;
        this.requestClass = requestClass;
        this.responseClass = responseClass;
    }

    @Override
    public String getApiURI() {
        return apiSubURI;
    }


    @Override
    public String getVersion() {
        return version;
    }

    @Override
    public Class getRequestClass() {
        return requestClass;
    }

    @Override
    public Class getResponseClass() {
        return responseClass;
    }
}