/**
 * fshows.com
 * Copyright (C) 2013-2024 All Rights Reserved.
 */
package com.fshows.postar.response.merchant;

import com.fshows.postar.response.PostarBizRes;
import lombok.Data;

/**
 * @author weikunpeng
 * @version PostarMerchantQueryRes.java, v 0.1 2024-10-09 10:15 weikunpeng
 */
@Data
public class PostarMerchantQueryRes extends PostarBizRes {

    /**
     * 机构号
     * 商户在国通系统入网机构号
     */
    private String agetId;

    /**
     * 商户号
     * 国通系统600商户号
     */
    private String custId;

    /**
     * 商户名称
     */
    private String busName;

    /**
     * 商户简称
     * 用于微信、支付宝商户简称及其账单显示
     */
    private String refName;

    /**
     * 商户类型
     * 1普通商户；2小微商户
     */
    private String custType;

    /**
     * 营业执照号
     * 商户类型为“普通”时返回
     */
    private String licenseno;

    /**
     * 营业执照照片
     */
    private String busPhotoFront;

    /**
     * 营业执照有效期开始日期
     * 格式YYYYMMDD
     */
    private String busStartDate;

    /**
     * 营业执照有效期结束日期
     * 格式YYYYMMDD, 永久返回"长期"
     */
    private String busEndDate;

    /**
     * 事业单位证明函照片
     */
    private String filed4;

    /**
     * 经营类型
     * 商户类型为“小微”时返回，01 门店场所 02流动经营/便民服务 03线上商品/服务交易
     */
    private String manageType;

    /**
     * 主体类型
     * 商户类型为“普通”时返回，1个体工商户 2企业 3政府及事业单位 5其他机构组织
     */
    private String busType;

    /**
     * 所属行业
     */
    private String mcccode;

    /**
     * 省
     */
    private String provId;

    /**
     * 市
     */
    private String cityId;

    /**
     * 区/县
     */
    private String areaId;

    /**
     * 详细地址
     */
    private String custAddr;

    /**
     * 经营者姓名
     */
    private String custName;

    /**
     * 身份证号码
     */
    private String credNo;

    /**
     * 手机号
     */
    private String mobileNo;

    /**
     * 身份证有效期开始日期
     * 格式YYYYMMDD
     */
    private String credStartDate;

    /**
     * 身份证有效期结束日期
     * 格式YYYYMMDD，永久返回"长期"
     */
    private String credEndDate;

    /**
     * 身份证正面图
     */
    private String credPhotoFront;

    /**
     * 身份证反面图
     */
    private String credPhotoBack;

    /**
     * 结算类型
     * 0：D0；1: T1；2：D1
     */
    private String stlType;

    /**
     * 提现D1附加手续费
     * 单位%，结算类型为T1时为空
     */
    private String rateTx;

    /**
     * 账户结算类型
     * 01 对公 02法人对私 03非法人对私
     */
    private String accountType;

    /**
     * 持卡人姓名
     */
    private String accountName;

    /**
     * 结算卡号
     */
    private String accountNo;

    /**
     * 结算卡正面照
     * 对公上传的“开户许可证/印鉴卡”，法人对私和非法人对私须上传“结算卡正面照”
     */
    private String authPic;

    /**
     * 开户行（银行缩写）
     */
    private String bankCode;

    /**
     * 非法人对私上传的授权书
     */
    private String authCert;

    /**
     * 非法人对私身份证反面
     */
    private String credPicB;

    /**
     * 非法人对私身份证正面
     */
    private String credPicF;

    /**
     * 结算人收银台照
     * 小微商户返回
     */
    private String jsrcPhoto;

    /**
     * 经营场所内景照
     */
    private String indoorScenePhoto;

    /**
     * 收银台照
     */
    private String cashierPhoto;

    /**
     * 经营场所门头照
     */
    private String doorHeaderPhoto;

    /**
     * 材料5
     */
    private String filed5;

    /**
     * 材料3
     */
    private String filed3;

    /**
     * 材料2
     */
    private String filed2;

    /**
     * 材料1
     */
    private String filed1;

    /**
     * 微信费率
     */
    private String rateWx;

    /**
     * 支付宝费率
     */
    private String rateZfb;

    /**
     * 银联扫码贷记卡扣率小于1000费率%
     */
    private String rateYlRat0;

    /**
     * 银联扫码贷记卡扣率大于1000费率%
     */
    private String rateYlRat1;

    /**
     * 银联扫码借记卡扣率小于1000费率 %
     */
    private String rateYlCap0;

    /**
     * 银联扫码借记卡扣率大于1000费率%
     */
    private String rateYlCap1;

    /**
     * 借记卡标准类消费封顶值(分)
     */
    private String moneyPosJb;

    /**
     * 借记卡优惠类消费封顶值(分)
     */
    private String moneyPosJy;

    /**
     * 云闪付结算费率（%）
     */
    private String ratePosS;

    /**
     * 抖音费率（%）。
     * 单位%，支持小数点后三位。
     */
    private String dySettRate;

    /**
     * 免签免密结算费率（%）
     */
    private String ratePosM;

    /**
     * 贷记卡标准类结算费率（%）
     */
    private String ratePosDb;

    /**
     * 借记卡标准类结算费率（%）
     */
    private String ratePosJb;

    /**
     * 贷记卡优惠类结算费率（%）
     */
    private String ratePosDy;

    /**
     * 图片接口时间戳
     */
    private String timestamp;

    /**
     * 报备产品类型
     * 0全产品 1扫码 2刷卡
     */
    private String custChanType;

    /**
     * 是否支持退款
     * ‘0’关；‘1’开
     */
    private String refPower;

    /**
     * 借记卡优惠类结算费率（%）
     */
    private String ratePosJy;

    /**
     * 银联扫码借记卡(≤1000)封顶值 (分)
     */
    private String ylJFdDef;

    /**
     * 银联扫码借记卡(>1000)封顶值(分)
     */
    private String ylJFd2Def;

    /**
     * 关联落地银行
     */
    private String fallAgetId;
}