/*
 * 51qbiz.id
 * Copyright (C) 2021-2023 All Rights Reserved.
 */
package com.fshows.postar.response.bankactivity.detail;

import com.fshows.postar.response.PostarBizRes;
import lombok.Data;

import java.io.Serializable;

/**
 * 商户报名情况查询响应数据
 *
 * @author Xujianwei
 * @version PostarActSubReq.java, v 0.1 2024-11-22 16:14 Xujianwei
 */
@Data
public class QuerySignUpActSubData implements Serializable {
    private static final long serialVersionUID = -482265402250676499L;

    /**
     * 商户号
     */
    private String custId;
    /**
     * 商户名称
     */
    private String busName;
    /**
     * 落地银行编号
     */
    private String fallAgetId;
    /**
     * 落地银行名称
     */
    private String ageName;
    /**
     * 银行补贴活动编号
     */
    private String subId;
    /**
     * 银行补贴活动名称
     */
    private String polName;
    /**
     * 报名方式：0-星驿秘书APP报名，1-国通后台，2-后台补贴配置新增，3-机构平台批量报名， 4-服务化ISV
     */
    private String applyWay;
    /**
     * 开卡状态：0-已申请、1-已预约、2-已开卡、3-开卡失败、4-已绑定
     */
    private String cardStatus;
    /**
     * 报名状态：0-未报名、1-报名中、2-报名成功 、3-报名失败
     */
    private String regisStatus;
    /**
     * 审核状态：0-未审核 ，1-已审核
     */
    private String auditStatus;
    /**
     * 发送状态：0-未发送，1-已发送（指发送给银行方）
     */
    private String sendStatus;
    /**
     * 报名时间：指提交报名的时间
     */
    private String regisTime;
    /**
     * 审核时间
     */
    private String auditTime;
    /**
     * 发送时间
     */
    private String sendTime;
    /**
     * 配置时间
     */
    private String confTime;
    /**
     * 失败原因
     */
    private String failReason;
}
