/**
 * fshows.com
 * Copyright (C) 2013-2024 All Rights Reserved.
 */
package com.fshows.postar.request.trade;

import com.fshows.postar.request.PostarBaseReq;
import lombok.Data;

import javax.validation.constraints.NotBlank;

/**
 * 预授权撤销请求
 *
 * @author Cascade
 * @version PostarPreAuthCancelReq.java, v 0.1 2025-12-08 14:45 Cascade
 */
@Data
public class PostarPreAuthCancelReq extends PostarBaseReq {
    private static final long serialVersionUID = 2958374928734958723L;

    /**
     * 机构号
     * 商户所在国通系统内机构号（或虚拟机构号），场景应用可以填默认值：FWHHLD000000
     * (必填)
     */
    @NotBlank
    private String agetId;

    /**
     * 商户号
     * (必填)
     */
    @NotBlank
    private String custId;

    /**
     * 三方撤销订单号
     * (必填)
     */
    @NotBlank
    private String threeOrderNo;

    /**
     * 备注
     * (选填)
     */
    private String remark;

    /**
     * 原国通平台单号
     * 对应支付接口返回的orderNo（原国通平台订单号，原三方单号二选一）
     * (选填)
     */
    private String reOrderNo;

    /**
     * 原三方单号
     * (选填)
     */
    private String oldThreeNo;

    /**
     * 原订单日期
     * 格式：yyyyMMdd，如：20251111，不传默认查当天
     * (选填)
     */
    private String date;

    /**
     * 验签
     * (必填)
     */
    @NotBlank
    private String sign;
}
