/**
 * fshows.com
 * Copyright (C) 2013-2025 All Rights Reserved.
 */
package com.fshows.postar.request.share.dict;

import com.fshows.postar.request.PostarBaseReq;
import lombok.Data;

import javax.validation.constraints.NotBlank;

/**
 * 查询联行号信息请求
 *
 * @author wangyi
 * @version PostarGetBranchInfoReq.java, v 0.1 2025-12-10 09:30 wangyi
 */
@Data
public class PostarGetBranchInfoReq extends PostarBaseReq {

    /**
     * 银行缩写
     * 调用"银行信息查询"接口获取
     * 必填: 是
     */
    @NotBlank
    private String bankCode;

    /**
     * 市编号
     * 调用"银行市信息-联行号"接口获取
     * 必填: 是
     */
    @NotBlank
    private String code;

    /**
     * 支行名称
     * 必填: 是
     */
    @NotBlank
    private String bankName;
}
