/**
 * fshows.com
 * Copyright (C) 2013-2025 All Rights Reserved.
 */
package com.fshows.postar.request.share.customer;

import com.fshows.postar.request.PostarBaseReq;
import com.fshows.postar.request.share.customer.detail.BatchCustInfo;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotEmpty;
import java.util.List;

/**
 * 批量分账授权申请接口-收单统一结算(XZY044)请求
 *
 * @author wangyi
 * @version PostarAuthorizationSplitBatchReq.java, v 0.1 2025-12-10 wangyi
 */
@Data
public class PostarAuthorizationSplitBatchReq extends PostarBaseReq {

    /**
     * 分账功能管理员商户
     * 600商户在星驿付的唯一代码，作为分账出款方
     * 必填: 是
     */
    @NotBlank
    private String mainCustId;

    /**
     * 请求时间戳
     * 格式：yyyyMMddHHmmss
     * 必填: 是
     */
    @NotBlank
    private String timestamp;

    /**
     * 批量签约商户信息
     * 必填: 是
     */
    @NotEmpty
    private List<BatchCustInfo> custInfoList;

    /**
     * 签约对象
     * 0接收方签约，1商户方签约
     * 必填: 是
     */
    @NotBlank
    private String signTarget;
}
