/**
 * fshows.com
 * Copyright (C) 2013-2025 All Rights Reserved.
 */
package com.fshows.postar.request.share.collect.detail;

import lombok.Data;

/**
 * 归集编辑信息
 *
 * @author wangyi
 * @version CollectEditInfo.java, v 0.1 2025-12-10 wangyi
 */
@Data
public class CollectEditInfo {

    /**
     * 归集功能管理员商户的600商户号
     * 必填: 是
     */
    private String mainCustId;

    /**
     * 商户编号
     * 归集商户编号，custId、customerId必须送一个优先匹配custId
     * 必填: 否
     */
    private String custId;

    /**
     * 客户编号
     * 归集接收方客户编号，custId、customerId必须送一个优先匹配custId
     * 必填: 否
     */
    private String customerId;

    /**
     * 最大归集比例
     * 单位%，例如送1就是1%
     * 必填: 否
     */
    private String maxValue;

    /**
     * 标签
     * 必填: 否
     */
    private String tag;

    /**
     * 是否合并入账
     * 0-否 1-是，默认否
     * 必填: 否
     */
    private String isMergeWithDraw;
}
