/**
 * fshows.com
 * Copyright (C) 2013-2024 All Rights Reserved.
 */
package com.fshows.postar.request.merchant;

import com.fshows.postar.request.PostarBaseReq;
import lombok.Data;

import javax.validation.constraints.NotBlank;

/**
 * @author weikunpeng
 * @version PostarMiniChangeReq.java, v 0.1 2024-10-09 09:15 weikunpeng
 */
@Data
public class PostarMiniChangeReq extends PostarBaseReq {

    /**
     * 进件机构号。
     * 若“机构号”字段为虚拟机构号，则“进件机构号”字段必传。
     * 可选: 否
     */
    private String applyAgetId;

    /**
     * 登入账号（手机号）。
     * 该手机号可登录国通商户APP。
     * 必填: 是
     */

    private String custLogin;

    /**
     * 商户号。
     * 必填: 是
     */

    private String custId;

    /**
     * 商户名称。
     * 建议输入市+名称+主营，长度控制在50个字以内（100个字符以内），
     * 建议长度5-20个字（10-40个字符），系统将根据银联规范对名称进行长度补充与截取，
     * 不足5个字的将补充“省市”信息，超出20个字的将截取后20位。
     * 必填: 是
     */

    private String busName;

    /**
     * 经营类型。
     * 01 门店场所，02 流动经营/便民服务，03 线上商品/服务交易。
     * 必填: 是
     */

    private String manageType;

    /**
     * 所属行业。
     * 基础信息获取板块内，使用获取一级mcc目录后获取获取二级mcc目录，
     * 该字段根据二级MCC目录对应行业编号。
     * 必填: 是
     * 后续: 国通不能修改，并且也不需要传递了
     */
//    @NotBlank
//    private String mcccode;

    /**
     * 省。基础信息获取板块-“获取省”接口。
     * 必填: 是
     */

    private String provId;

    /**
     * 市。基础信息获取板块-“获取市”接口。
     * 必填: 是
     */

    private String cityId;

    /**
     * 区/县。基础信息获取板块-“获取区县”接口。
     * 必填: 是
     */

    private String areaId;

    /**
     * 商户经营地址。
     * 长度控制在100个字（200个字符），建议长度5-30个字（10-60个字符），
     * 系统将根据银联规范对地址进行长度补充与截取，
     * 少于5个字添加省市区进行补足，超过30个字的向后取值30个字。
     * 必填: 是
     */

    private String custAddr;

    /**
     * 经营者姓名。
     * 必填: 是
     */

    private String custName;

    /**
     * 身份证号码。
     * 必填: 是
     */

    private String credNo;

    /**
     * 身份证有效期开始日期。格式：YYYYMMDD。
     * 必填: 是
     */

    private String credStartDate;

    /**
     * 身份证有效期结束日期。格式：YYYYMMDD，永久传"长期"。
     * 必填: 是
     */

    private String credEndDate;

    /**
     * 经营者联系方式，手机号。
     * 可与“登入账号”一致。
     * 必填: 是
     */

    private String mobileNo;

    /**
     * 持卡人姓名。
     * 必填: 是
     */

    private String accountName;

    /**
     * 结算卡号。
     * 必填: 是
     */

    private String accountNo;

    /**
     * 开户行（缩写）。
     * 调用基础信息板块-银行信息查询/根据银行卡号获取银行信息获取。
     * 必填: 是
     */

    private String bankCode;

    /**
     * 结算类型。
     * 1: T1，2: D1，若需开通D0可前往国通商户APP开通或联系联调人员获取D0-SDK主键嵌入自有程序。
     * 示例: 2
     * 必填: 是
     */

    private String stlType;

    /**
     * 微信借记卡费率。
     * 单位%，支持小数点后三位。
     * 必填: 是
     */

    private String rateWx;

    /**
     * 微信贷记卡费率。
     * 单位%，支持小数点后三位。
     * 可选: 否
     */
    private String rateWxDj;

    /**
     * 支付宝费率。
     * 单位%，支持小数点后三位。
     * 必填: 是
     */

    private String rateZfb;

    /**
     * 银联扫码借记卡扣率小于1000。
     * 单位%，支持小数点后三位。
     * 必填: 是
     */

    private String rateYlCap0;

    /**
     * 银联扫码借记卡扣率大于1000。
     * 单位%，支持小数点后三位。
     * 必填: 是
     */

    private String rateYlCap1;

    /**
     * 银联扫码贷记卡扣率小于1000。
     * 单位%，支持小数点后三位。
     * 必填: 是
     */

    private String rateYlRat0;

    /**
     * 银联扫码贷记卡扣率大于1000。
     * 单位%，支持小数点后三位。
     * 必填: 是
     */

    private String rateYlRat1;

    /**
     * 提现手续费D1附加手续费。
     * 单位%，支持小数点后两位，结算类型为T1时传空值。
     * 必填: 是
     */

    private String rateTx;

    /**
     * 借记卡优惠类结算费率（%）。
     * 单位%，支持小数点后三位。
     * 必填: 是
     */

    private String ratePosJy;

    /**
     * 借记卡标准类结算费率（%）。
     * 单位%，支持小数点后三位。
     * 必填: 是
     */

    private String ratePosJb;

    /**
     * 贷记卡优惠类结算费率（%）。
     * 单位%，支持小数点后三位。
     * 必填: 是
     */

    private String ratePosDy;

    /**
     * 贷记卡标准类结算费率（%）。
     * 单位%，支持小数点后三位。
     * 必填: 是
     */

    private String ratePosDb;

    /**
     * 借记卡优惠类消费封顶值。
     * 单位分。
     * 必填: 是
     */

    private String moneyPosJy;

    /**
     * 借记卡标准类消费封顶值。
     * 单位分。
     * 必填: 是
     */

    private String moneyPosJb;

    /**
     * 免签免密结算费率（%）。
     * 单位%，支持小数点后三位。
     * 必填: 是
     */

    private String ratePosM;

    /**
     * 刷卡闪付结算费率（%）。
     * 单位%，支持小数点后三位。
     * 必填: 是
     */

    private String ratePosS;

    /**
     * 抖音费率（%）。
     * 单位%，支持小数点后三位。
     */
    private String dySettRate;

    /**
     * 银联扫码借记卡(≤1000)封顶值。
     * 单位分，根据机构政策区间上送，未上送时会取政策的默认封顶值。
     * 若政策未配置封顶值，则无需上送（代表不封顶）。
     * 可选: 否
     */
    private String ylJFdDef;

    /**
     * 银联扫码借记卡(>1000)封顶值。
     * 单位分，根据机构政策区间上送，未上送时会取政策的默认封顶值。
     * 若政策未配置封顶值，则无需上送（代表不封顶）。
     * 可选: 否
     */
    private String ylJFd2Def;

    /**
     * 关联落地银行机构号。
     * 当610机构类型为“行业代理/联合收单”时，可调用进件-基础信息获取-关联落地银行品牌查询、
     * 落地银行下级机构查询接口，获取落地银行。会校验结算卡是否属于落地银行。
     * 若商户已存在落地银行不允许修改（为空代表不修改原值）。
     * 可选: 否
     */
    private String fallAgetId;

    /**
     * 是否支持退款。
     * ‘0’关；‘1’开。
     * 必填: 是
     */

    private String refPower;

    /**
     * 报备产品类型。
     * 0全产品，1扫码，2刷卡。
     * 必填: 是
     */

    private String custChanType;

    /**
     * 经度。
     * 商户经营地址所在经度，小数点后仅支持上传后5位，进行截取。
     * 必填: 否
     */
    private String longitude;

    /**
     * 纬度。
     * 商户经营地址所在纬度，小数点后仅支持上传后5位，进行截取。
     * 必填: 否
     */
    private String latitude;

    /**
     * 图片接口时间戳。
     * 首次进件必传，若商户首次进件被驳回后无需修改图片则无需传输。
     * 基础进件板块-“商户进件上传图片”-时间戳timestamp字段，一个商户一个时间戳。
     * 使用首张图片国通服务器返回时间戳。
     * 可选: 否
     */
    private String timestamp;
}