/*
 * ailike.com
 * Copyright (C) 2022-2025 All Rights Reserved.
 */
package com.fshows.postar.request.merchant;

import com.fshows.postar.request.PostarBaseReq;
import lombok.Data;

import javax.validation.constraints.NotBlank;

/**
 * @author zhangling
 * @version PostarBindPosReq.java, v 0.1 2025-12-09 14:17 zhangling
 */
@Data
public class PostarBindPosReq extends PostarBaseReq {

    /**
     * 商户号。
     * 必填: 是
     */
    @NotBlank
    private String custId;

    /**
     * 设备SN
     */
    private String sn;

    /**
     * 码牌链接
     */
    private String codeUrl;

    /**
     * 签约方案
     * 0：线下0元先享、
     */
    private String signSolution;

    /**
     * 时间戳
     * 格式：yyyyMMddHHmmss
     */
    private String timeStamp;
}