package com.fshows.postar.enums;

public enum UploadImageFlagEnum {
    ID_CARD_FRONT(1, "身份证正面照片", "credPhotoFront"),
    ID_CARD_BACK(2, "身份证反面照片", "credPhotoBack"),
    ACCOUNT_LICENSE(3, "对公上传“开户许可证/印鉴卡”", "authPic"),
    BUSINESS_SIGNBOARD(4, "营业场所门头照", "doorHeaderPhoto"),
    BUSINESS_INTERIOR(5, "营业场所内景照", "indoorScenesPhoto"),
    SUPPLEMENTARY_MATERIAL_1(6, "补充材料①", "filed1"),
    SUPPLEMENTARY_MATERIAL_2(7, "补充材料②", "filed2"),
    SUPPLEMENTARY_MATERIAL_3(8, "补充资料③（手持结算卡照片）", "infoPhoto3"),
    INSTITUTION_PROOF(9, "事业单位证明函照片", "filed4"),
    SUPPLEMENTARY_MATERIAL_5(10, "补充材料⑤", "filed5"),
    BUSINESS_LICENSE(12, "营业执照", "busPhotoFront"),
    NON_LEGAL_PERSON_ID_CARD_FRONT(13, "非法人对私身份证正面照", "credPicF"),
    NON_LEGAL_PERSON_ID_CARD_BACK(14, "非法人对私身份证反面照", "credPicB"),
    NON_LEGAL_PERSON_AUTHORIZATION(15, "非法人对私上传的授权书", "authCert"),
    SETTLEMENT_PERSON_SIGNBOARD(16, "结算人站门头照（储备字段无需处理）", "stlDoor"),
    NON_LEGAL_PERSON_SETTLEMENT_AUTHORIZATION(17, "非法人授权结算书合影", "stlAuth"),
    CASHIER_DESK(18, "收银台照", "cashierPhoto"),
    SETTLEMENT_PERSON_CASHIER_DESK(19, "结算人收银台照", "jsrcPhoto"),
    NETWORK_AGREEMENT_1(20, "入网协议照①", "infoPhoto1"),
    NETWORK_AGREEMENT_2(21, "入网协议照②", "infoPhoto2"),
    NETWORK_AGREEMENT_3(22, "入网协议照③", "infoPhoto3"),
    NETWORK_AGREEMENT_4(23, "入网协议照④", "netPhoto1"),
    NETWORK_AGREEMENT_5(24, "入网协议照⑤", "netPhoto2"),
    NETWORK_AGREEMENT_6(25, "入网协议照⑥", "netPhoto3"),
    NETWORK_AGREEMENT_7(26, "入网协议照⑦", "netPhoto4"),
    NETWORK_AGREEMENT_8(27, "入网协议照⑧", "netPhoto5"),
    NETWORK_AGREEMENT_9(28, "入网协议照⑨", "netPhoto6"),
    NETWORK_AGREEMENT_10(29, "入网协议照⑩", "netPhoto7"),
    NETWORK_AGREEMENT_11(35, "入网协议照⑪", "netPhoto8");

    private final int code;
    private final String description;
    private final String fieldName;

    UploadImageFlagEnum(int code, String description, String fieldName) {
        this.code = code;
        this.description = description;
        this.fieldName = fieldName;
    }

    public static UploadImageFlagEnum getByCode(int code) {
        for (UploadImageFlagEnum documentType : values()) {
            if (documentType.getCode() == code) {
                return documentType;
            }
        }
        return null;
    }

    public int getCode() {
        return code;
    }

    public String getDescription() {
        return description;
    }

    public String getFieldName() {
        return fieldName;
    }

    @Override
    public String toString() {
        return "DocumentType{" +
                "code=" + code +
                ", description='" + description + '\'' +
                ", fieldName='" + fieldName + '\'' +
                '}';
    }
}
