/**
 * fshows.com
 * Copyright (C) 2013-2024 All Rights Reserved.
 */
package com.fshows.postar.request.trade.detail;

import com.alibaba.fastjson.annotation.JSONField;
import lombok.Data;
import org.hibernate.validator.constraints.Length;

import java.util.List;

/**
 * @author wangqilei
 * @version OrderGoodsInfo.java, v 0.1 2024-06-05 3:41 PM wangqilei
 */
@Data
public class OrderGoodsInfo {
    /**
     * 订单原价
     * 1.商户侧一张小票订单可能被分多次支付，订单原价用于记录整张小票的交易金额。
     * 2.当订单原价与支付金额不相等，则不享受优惠。
     * 3.该字段主要用于防止同一张小票分多次支付，以享受多次优惠的情况，正常支付订单不必上传此参数。
     * (选填)
     */
    @JSONField(name = "cost_price")
    private Integer costPrice;

    /**
     * 商家小票 ID
     * wx123
     * (特殊必填)
     */
    @JSONField(name = "receipt_id")
    private String receiptId;

    /**
     * 单品列表，单品信息，使用 Json 数组格式提交
     * (必填)
     */
    @JSONField(name = "goods_detail")
    private List<OrderGoodsDetail> goodsDetailList;
}