/**
 * fshows.com
 * Copyright (C) 2013-2024 All Rights Reserved.
 */
package com.fshows.postar.response.trade.detail;

import com.alibaba.fastjson.annotation.JSONField;
import lombok.Data;

/**
 * @author wangqilei
 * @version GoodsDetail.java, v 0.1 2024-06-05 5:56 PM wangqilei
 */
@Data
public class GoodsDetail {
    /**
     * 商品编码，用于唯一标识商品
     * (必填)
     */
    @JSONField(name = "goods_id")
    private String goodsId;

    /**
     * 用户自定义的商品备注信息
     * (特殊必填)
     */
    @JSONField(name = "goods_remark")
    private String goodsRemark;

    /**
     * 商品享受的优惠金额
     * (必填)
     */
    @JSONField(name = "discount_amount")
    private String discountAmount;

    /**
     * 用户添加到购物车的商品数量
     * (必填)
     */
    private String quantity;

    /**
     * 商品的单位价格
     * (必填)
     */
    private String price;

}