/**
 * fshows.com
 * Copyright (C) 2013-2025 All Rights Reserved.
 */
package com.fshows.postar.response.merchant;

import com.fshows.postar.response.PostarBizRes;
import lombok.Data;

import javax.validation.constraints.NotBlank;

/**
 * @author wangyi
 * @version PostarApplyMerchantSettlementRse.java, v 0.1 2025-06-13 17:05 wangyi
 */
@Data
public class PostarApplyMerchantSettlementRes extends PostarBizRes {


    private String agetId;

    /**
     * 商户号。
     * 必填: 是
     */
    @NotBlank
    private String custId;

    /**
     * 申请业务类型
     * 00-日切商户，01-合并入账商户，02-提前批商户。
     * 示例：00-日切商户：支持0-23点日切，比如日切点是10点，则代表商户昨天10点至今天9:59:59的交易在10点进行清分到账。01-合并入账商户：表示同个结算信息的商户，可以合并一笔进行入账。02-提前批商户：表示商户可比常规清算时间提前清算到账（提前至早上6点左右到账）
     *
     * 必填: 是
     */
    @NotBlank
    private String busType;

    /**
     * 日切时间
     */
    private String riqieTime;

    /**
     * 合并入账商户
     */
    private String hbCustId;

    /**
     * 开通状态
     * 00-开启 01-关闭。备注：合并入账商户，接口申请成功即默认为开通进行返回
     */
    @NotBlank
    private String status;

    /**
     * 审核状态
     * 00-审核中 01-审核通过 02-审核拒绝。备注：合并入账商户,接口修改成功就返回通过
     */
    private String authStatus;

    /**
     * 审核状态说明
     */
    private String remark;

    /**
     * 申请时间
     */
    private String orderTime;
}