/**
 * fshows.com
 * Copyright (C) 2013-2024 All Rights Reserved.
 */
package com.fshows.postar.request.merchant;

import com.fshows.postar.request.PostarBaseReq;
import lombok.Data;

import javax.validation.constraints.NotBlank;

/**
 * @author weikunpeng
 * @version PostarAnxinSignCompanyReq.java, v 0.1 2024-10-09 16:05 weikunpeng
 */
@Data
public class PostarAnxinSignCompanyReq extends PostarBaseReq {
    /**
     * 进件机构号
     * 若“机构号”字段为FWH开头的虚拟机构号，则该字段必传
     */
    private String applyAgentId;

    /**
     * 登录账号（手机号）
     * 该字段必传
     */
    @NotBlank
    private String custLogin;

    /**
     * 商户注册名称
     * 进件时商户名称或营业执照主体名称，必传字段
     */
    @NotBlank
    private String enterpriseName;

    /**
     * 8企业营业执照、
     * B港澳居民往来内地通行证、
     * C台湾居民来往大陆通行证、
     * H事业单位法人证书、
     * J社会团体登记证书、
     * N企业统一社会信用代码
     */
    @NotBlank
    private String identType;


    /**
     * 证件号码
     * 根据证件类型传对应证件号
     */
    @NotBlank
    private String identNo;

    /**
     * 电子邮箱
     * 邮箱与手机号必填其一
     */
    private String email;

    /**
     * 手机号
     * 邮箱与手机号必填其一
     */
    private String phone;

    /**
     * 营业执照号
     * 必传字段
     */
    @NotBlank
    private String licenseNo;

    /**
     * 企业（单位）联系电话
     * 必传字段
     */
    @NotBlank
    private String enterprisePhone;

    /**
     * 企业（单位）地址
     * 必传字段
     */
    @NotBlank
    private String address;

    /**
     * 法人名称
     * 必传字段
     */
    @NotBlank
    private String transName;

    /**
     * 法人身份证号
     * 必传字段
     */
    @NotBlank
    private String transNo;

    /**
     * 结算人姓名
     * 三要素认证，必传字段
     */
    @NotBlank
    private String accountName;

    /**
     * 结算卡号
     * 三要素认证，必传字段
     */
    @NotBlank
    private String accountNo;

    /**
     * 身份证号
     */
    @NotBlank
    private String credNo;

    /**
     * 企业/商户名称
     */
    @NotBlank
    private String busName;

    /**
     * 时间戳
     * 格式yyyyMMddHHmmss
     */
    private String timeStamp;
}