/*
 * 51qbiz.id
 * Copyright (C) 2021-2023 All Rights Reserved.
 */
package com.fshows.postar.request.bankactivity;

import com.fshows.postar.request.PostarBaseReq;
import lombok.Data;

import javax.validation.constraints.NotNull;

/**
 * 商户报名情况查询请求/商户补贴活动明细请求
 * @author Xujianwei
 * @version PostarActSubReq.java, v 0.1 2024-11-22 16:14 Xujianwei
 */
@Data
public class PostarQuerySignUpActSubReq extends PostarBaseReq {
    private static final long serialVersionUID = -482265402250676499L;

    /**
     * 商户号，不填默认查询全部
     */
    @NotNull(message = "商户号：custId不能为空")
    private String custId;
    /**
     * 页码	不填默认1
     */
    private String page;
    /**
     * 每页数量	不填默认20
     */
    private String size;
    /**
     * 时间戳 格式yyyyMMddHHmmss
     */
    @NotNull(message = "时间戳：timeStamp不能为空")
    private String timeStamp;

}
