/**
 * fshows.com
 * Copyright (C) 2013-2024 All Rights Reserved.
 */
package com.fshows.postar.request.trade;

import com.fshows.postar.request.PostarBaseReq;
import lombok.Data;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotBlank;

/**
 * @author wangqilei
 * @version PostarUnionUserIdReq.java, v 0.1 2024-06-05 6:02 PM wangqilei
 */
@Data
public class PostarGetCodeUrlReq extends PostarBaseReq {

    private static final long serialVersionUID = 8760578679923322033L;

    /**
     * 商户号
     * 商户所在国通系统内的商户号
     * (必填)
     */
    @NotBlank
    private String custId;

    /**
     * 服务商第三方订单号
     * (必填)
     */
    @NotBlank
    private String orderNo;

    /**
     * 金额（分）
     * (必填)
     */
    @NotBlank
    private String txamt;

    /**
     * 订单失效时间
     * 未传输时默认15，最小1分钟，最大值15分钟，单位（分）。
     * 以订单生成时间起，如10:15:00发起下单，则10:31:00点击无法支付订单失效
     * (选填)
     */
    private Integer outTime;

    /**
     * 支付类型
     * 00确认支付、01直接支付。
     * 00确认支付(唤起国通收银台查看金额信息，填写备注信息后点击支付完成交易，当接口备注与收银台填写备注不一致时，默认取收银台填写备注进行覆盖)
     * 01直接支付 (未打开国通收银台，直接唤起支付)
     * 未传默认上送00支付确认
     * (必填)
     */
    private String payType;

    /**
     * 备注
     */
    private String remark;

    /**
     * 异步通知地址
     * 未传时默认根据单项目配置异步地址进行通知，传输时根据请求异步地址进行通知，
     * 注：1.地址需提前报备国通进行转化，解析失败按照项目配置地址通知；2.退款无异步无需传输；3.数币交易暂不支持自定义异步地址
     * (特殊必填)
     */
    private String asyncNotify;

    /**
     * 接口请求时间. 格式yyyyMMddHHmmss
     */
    private String timeStamp;
}