/**
 * fshows.com
 * Copyright (C) 2013-2024 All Rights Reserved.
 */
package com.fshows.postar.request.trade;

import com.fshows.postar.request.PostarBaseReq;
import com.fshows.postar.request.trade.detail.OrderGoodsDetailList;
import com.fshows.postar.request.trade.detail.OrderGoodsInfo;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import java.util.List;

/**
 * @author wangqilei
 * @version PostarPayReq.java, v 0.1 2024-06-05 3:07 PM wangqilei
 */
@Data
public class PostarJsApiPayCreateReq extends PostarBaseReq {
    private static final long serialVersionUID = -5446268671099686017L;

    /**
     * 商户号
     * 商户所在国通系统内的商户号
     * (必填)
     */
    @NotBlank
    private String custId;

    /**
     * 服务商订单号（第三方订单号）
     * 该订单号需要唯一，最大长度40，只能由数字，大小写字母构成
     * (必填)
     */
    @NotBlank
    private String orderNo;

    /**
     * 订单金额
     * 单位分，国通系统内记录至流水（原订单交易金额）
     * (必填)
     */
    @NotBlank
    private String txamt;

    /**
     * 消费者的openid
     * 根据微信、支付宝、银联给出的官方文档获取，微信是openid，支付宝是userId（以 2088 开头），
     * 银联用户标识看前往对接前准备-“获取银联用户标识”接口获取
     * (必填)
     */
    @NotBlank
    private String openid;

    /**
     * 支付方式
     * 1.微信支付（小程序） 2.支付宝支付 3.银联支付
     * (必填)
     */
    @NotBlank
    private String payWay;

    /**
     * 消费者IP地址
     * 222.137.130.75
     * (必填)
     */
    @NotBlank
    private String ip;

    /**
     * 订单标题
     * 长度不能超过32
     * (选填)
     */
    private String title;

    /**
     * 自定义设备编号
     * 长度不能超过32
     * (选填)
     */
    private String driveNo;

    /**
     * 微信公众账号appid
     * 微信支付必传
     * (特殊必填)
     */
    private String wxAppid;

    /**
     * 微信交易类型（微信支付必传）
     * 5公众号 8小程序
     * (特殊必填)
     */
    private String traType;

    /**
     * 支付宝appid
     * 支付宝支付必传
     * (特殊必填)
     */
    private String zfbappid;

    /**
     * 支付通道
     * 对接前准备-“获取银联用户标识”接口获取，(银联支付必传)
     * (特殊必填)
     */
    private String atqTag;

    /**
     * 商户手机号，非必填
     * (选填)
     */
    private String custLogin;

    /**
     * 备注，订单说明
     * (选填)
     */
    private String remark;

    /**
     * 操作员号
     * 可传店员标识
     * (选填)
     */
    private String operator;

    /**
     * 纬度
     * 消费者设备支付定位，例：119.411869
     * (选填)
     */
    private String latitude;

    /**
     * 经度
     * 消费者设备支付定位，例：119.411869
     * (选填)
     */
    private String longitude;

    /**
     * 音箱编号
     * 有使用国通音箱的时候传输可指定音箱播报
     * (选填)
     */
    private String spNo;

    /**
     * 是否播报
     * 0不播报 1:播报，默认1，播报
     * (选填)
     */
    private String speakerSwitch;

    /**
     * 服务商机构标识码
     * 用于银联交易上送服务商机构PID使用
     * (选填)
     */
    private String fpid;

    /**
     * 订单失效时间
     * 未传输时默认15，最小1分钟，最大值15分钟，单位（分）。
     * 以订单生成时间起，如10:15:00发起下单，则10:31:00点击无法支付订单失效
     * (选填)
     */
    private Integer outTime;

    /**
     * 交易异步通知地址
     * 未传时默认根据单项目配置异步地址进行通知，传输时根据请求异步地址进行通知，
     * 注：1.地址需提前报备国通进行转化，解析失败按照项目配置地址通知；2.退款无异步无需传输
     * (选填)
     */
    private String asyncNotify;

    /**
     * 实时费率
     * 单位%，支持小数点后两位，特殊项目需平台配置相关权限时生效，用于计算该笔交易实际手续费费率值
     * (选填)
     */
    private String realTimeRate;

    /**
     * 支付宝侧的商户编号
     * (选填)
     */
    private String zfbCustId;

    /**
     * 买家账号
     * (选填)
     */
    private String zfbBuyerAccount;

    /**
     * 支付场景
     * 目前固定传 “jiayou”
     * (特殊必填)
     */
    private String zfbConsumeOutScene;

    /**
     * 加油用户来源
     * 目前固定传 “mayijiayou”。 商户传入业务信息，具体值要和支付宝约定，应用于安全，营销等参数直传场景，
     * 格式为 json 格式，例如：{""data"":""123""}如果用于标识加油支付业务：key 值固定，对应 value 值根据说明传入，
     * 例如：{""jiayouSource"":""mayijiayou"",""consumeOutScene"":""jiayou""}"
     * (选填)
     */
    private String zfbJiayouSource;

    /**
     * 推广参数
     * 目前固定传 “mayijiayou”
     * (特殊必填)
     */
    private String zfbJiayouPromoRule;

    /**
     * 商户侧门店编号
     * (选填)
     */
    private String zfbShopNo;

    /**
     * 扫码点餐场景类型
     * qr_order (店内扫码点餐)
     * pre_order (预点到店自提)
     * home_delivery (外送到家)
     * direct_payment (直接付款)
     * other (其他)
     * (选填)
     */
    private String foodOrderType;

    /**
     * 花呗分期
     * 花呗分期期数, 当前仅支持传入3、6、12
     * (特殊必填)
     */
    private String hbFqNum;

    /**
     * 信用卡分期
     * 信用卡分期数，当前支持传入 3、6、12
     * (特殊必填)
     */
    private String crFqNum;

    /**
     * 原订单金额（单位分
     * 星POS中转项目必传
     * (选填)
     */
    private String txamtOrder;

    /**
     * 单品优惠功能字段，JSON数组格式（支付宝支付）（未发布）
     * (非必填)
     */
    private List<OrderGoodsDetailList> goodsDetailList;

    /**
     * 单品优惠功能字段，JSON格式（微信支付）
     * (非必填)
     */
    private OrderGoodsInfo goodsInfo;

    /**
     * 接口请求时间. 格式yyyyMMddHHmmss
     */
    private String timeStamp;
}