/**
 * fshows.com
 * Copyright (C) 2013-2024 All Rights Reserved.
 */
package com.fshows.postar.response.trade.detail;

import com.alibaba.fastjson.annotation.JSONField;
import lombok.Data;

import java.util.List;

/**
 * @author wangqilei
 * @version PromotionDetail.java, v 0.1 2024-06-05 5:54 PM wangqilei
 */
@Data
public class PromotionDetail {
    /**
     * 券或者立减优惠id
     * (选填)
     */
    @JSONField(name = "promotion_id")
    private String promotionId;

    /**
     * 优惠名称
     * (选填)
     */
    private String name;

    /**
     * 优惠范围（GLOBAL- 全场代金券 SINGLE- 单品优惠）
     * (选填)
     */
    private String scope;

    /**
     * 优惠类型（COUPON- 代金券 DISCOUNT- 优惠券）
     * (选填)
     */
    private String type;

    /**
     * 优惠券面额
     * (选填)
     */
    private String amount;

    /**
     * 活动 ID
     * (选填)
     */
    @JSONField(name = "activity_id")
    private String activityId;

    /**
     * 微信出资
     * (选填)
     */
    @JSONField(name = "wxpay_contribu")
    private String wxpayContribu;

    /**
     * 商户出资
     * (选填)
     */
    @JSONField(name = "merchant_contribute")
    private String merchantContribute;

    /**
     * 	其他出资
     * (选填)
     */
    @JSONField(name = "wxpay_contribu")
    private String otherContribute;

    /**
     * 单品列表，json数组
     */
    @JSONField(name = "goods_detail")
    private List<GoodsDetail> goodsDetailList;
}