/**
 * fshows.com
 * Copyright (C) 2013-2024 All Rights Reserved.
 */
package com.fshows.postar.response.trade;

import com.fshows.postar.response.PostarBizRes;
import lombok.Data;

/**
 * @author wangqilei
 * @version PostarCloseOrderRes.java, v 0.1 2024-06-05 6:04 PM wangqilei
 */
@Data
public class PostarUnionUserIdRes extends PostarBizRes {
    private static final long serialVersionUID = 9061909187606061684L;
    /**
     * 用户标识
     * 用于基础支付板块-统一下单接口（C扫B）内）“openid”字段
     * (必填)
     */
    private String userId;
    /**
     * 是否走ATQ支付通道
     * 0走ATQ通道、1银联小微、2开放平台，用于基础支付板块-统一下单接口（C扫B）内）“atqTag”字段
     * (必填)
     */
    private String atqTag;
}