/**
 * fshows.com
 * Copyright (C) 2013-2024 All Rights Reserved.
 */
package com.fshows.postar.request.trade;

import com.fshows.postar.request.PostarBizReq;
import lombok.Data;

import javax.validation.constraints.NotBlank;

/**
 * @author wangqilei
 * @version PostarOrderQueryReq.java, v 0.1 2024-06-05 5:46 PM wangqilei
 */
@Data
public class PostarTradeQueryReq extends PostarBizReq {
    private static final long serialVersionUID = 8614842010474604690L;
    /**
     * 服务商订单号（第三方订单号）
     * 该订单号需要唯一，最大长度40，只能由数字，大小写字母构成， 对应星POS：tradeNo
     * (必填)
     */
    @NotBlank
    private String orderNo;

    /**
     * 机构号
     * 商户所在国通系统内机构号（或虚拟机构号）
     * (必填)
     */
    @NotBlank
    private String agetId;

    /**
     * 商户号
     * 商户所在国通系统内商户号
     * (必填)
     */
    @NotBlank
    private String custId;

    /**
     * 商户的手机号码
     * (特殊必填)
     */
    private String custLogin;

    /**
     * 查询收银系统推送pos订单时必传
     * 01，枚举：01：服务化查询
     * (特殊必填)
     */
    private String orderType;

    /**
     * 设备类型
     * 对应星pos：trmTyp
     * (选填)
     */
    private String type;

    /**
     * 操作员号
     * 对应星pos：oprId
     * (选填)
     */
    private String operator;

    /**
     * 对应星pos：请求ip：reqip
     * (选填)
     */
    private String tradingIp;

    /**
     * 接入方式 0:Android SDK 1:iOS SDK 2:windows SDK 3:直连 对应星pos：操作系统：opSys字段
     * (选填)
     */
    private String access;

    // 以下是星POS项目可传专属值
    /**
     * 设备号
     * 星POS项目可传，其他项目无需，长度8位数字，进件生成终端号，对应星pos：trmNo
     * (选填)
     */
    private String driveNo;
    /**
     * 查询流水	星POS项目必填
     * (选填)
     */
    private String qryNo;
    /**
     * 查询流水时间	星POS项目必填
     * (选填)
     */
    private String qryDt;
    /**
     * 字符集
     * 默认传00-GBK
     * (选填)
     */
    private String characterSet;
    /**
     * 纬度
     * 星POS项目可传，其他项目无需
     * (选填)
     */
    private String latitude;
    /**
     * 经度
     * 星POS项目可传，其他项目无需
     * (选填)
     */
    private String longitude;
}