/**
 * fshows.com
 * Copyright (C) 2013-2024 All Rights Reserved.
 */
package com.fshows.postar.request.trade;

import com.fshows.postar.request.PostarBaseReq;
import lombok.Data;

import javax.validation.constraints.NotBlank;

/**
 * @author wangqilei
 * @version PostarRefundCreateReq.java, v 0.1 2024-06-06 4:38 PM wangqilei
 */
@Data
public class PostarRefundCreateReq extends PostarBaseReq {
    private static final long serialVersionUID = -2352907155947960571L;

    /**
     * 服务商退款订单号
     * 第三方退款订单号，该订单号需要唯一，最大长度40，只能由数字，
     * 大小写字母构成（合作方重新生成的一个用来退款的订单号）。对应星POS：tradeNo
     * (必填)
     */
    @NotBlank
    private String orderNo;
    /**
     * 国通平台订单号（国通平台订单号，官方退款订单号，原第三方交易订单号三选一），
     * 对应支付接口返回的orderNo（国通平台订单号，官方退款订单号，原第三方交易订单号三选一）
     * (选填)
     */
    private String reOrderNo;

    /**
     * 官方退款订单号（国通平台订单号，官方退款订单号，原第三方交易订单号三选一），
     * 对应异步通知接口返回的T_ORDER_NO（国通平台订单号，官方退款订单号，原第三方交易订单号三选一）
     * (选填)
     */
    private String tOrderNo;

    /**
     * 原第三方交易订单号（国通平台订单号，官方退款订单号，原第三方交易订单号三选一），
     * 对应支付接口请求参数中的orderNo（国通平台订单号，官方退款订单号，原第三方交易订单号三选一），推荐原交易平台订单号
     * (特殊必填)
     */
    private String oldTOrderNo;

    /**
     * 商户号
     * 商户所在国通系统内商户号
     * (必填)
     */
    @NotBlank
    private String custId;

    /**
     * 退款金额
     * 单位分，支持部分退款。 对应星POS：txnAmt
     * (选填)
     */
    @NotBlank
    private String refundAmount;

    /**
     * 订单类型
     * 1支付宝 2微信 9银联（类型必须填写正确，与正向交易订单类型一致）12数币支付
     * (必填)
     */
    @NotBlank
    private String tag;

    /**
     * 异步通知接口地址
     * 特殊项目使用，默认直接返回退款情况，或调用退款查询确认退款状态，用于特殊项目，传输时根据请求地址进行通知，注：1.地址需提前报备国通进行转化，解析失败按照项目配置地址通知
     * (选填)
     */
    private String asyncNotifyUrl;

    /**
     * 商户的手机号
     * (选填)
     */
    private String custLogin;

    /**
     * 设备类型
     * 对应星pos：trmTyp
     * (特殊必填)
     */
    private String type;

    /**
     * 操作员号
     * 对应星pos：oprId
     * (特殊必填)
     */
    private String operator;

    /**
     * 请求ip
     * 对应星pos：reqip
     * (特殊必填)
     */
    private String tradingIp;

    /**
     * 接入方式
     * 0:Android SDK 1:iOS SDK 2:windows SDK 3:直连（默认填3）。对应星pos：opSys字段
     * (选填)
     */
    private String access;

    /**
     * 退款备注
     * 支持60个字符，数字、字母、文字
     * (特殊必填)
     */
    private String remark;

    /**
     * 设备号
     * 星POS项目可传，其他项目无需，长度8位数字，进件生成终端号。对应星pos：trmNo
     * (选填)
     */
    private String driveNo;

    /**
     * 批次号
     * 星POS项目可传，其他项目无需
     * (选填)
     */
    private String batchNo;

    /**
     * 交易日期
     * 星POS项目可传，其他项目无需
     * (选填)
     */
    private String oTxnDt;

    /**
     * 字符集
     * 默认传00-GBK
     * (选填)
     */
    private String characterSet;

    /**
     * 纬度
     * 星POS项目可传，其他项目无需
     * (选填)
     */
    private String latitude;

    /**
     * 经度
     * 星POS项目可传，其他项目无需
     * (选填)
     */
    private String longitude;

    /**
     * 原始交易日期
     * yyyyMMdd，邮支付必传，
     * (选填)
     */
    private String originTradeDate;
}