/**
 * fshows.com
 * Copyright (C) 2013-2024 All Rights Reserved.
 */
package com.fshows.postar.request.trade;

import com.fshows.postar.request.PostarBaseReq;
import lombok.Data;

import javax.validation.constraints.NotBlank;

/**
 * @author wangqilei
 * @version PostarOrderQueryReq.java, v 0.1 2024-06-05 5:46 PM wangqilei
 */
@Data
public class PostarOrderQueryReq extends PostarBaseReq {
    private static final long serialVersionUID = 8614842010474604690L;
    /**
     * 服务商订单号（第三方订单号）
     * 该订单号需要唯一，最大长度40，只能由数字，大小写字母构成， 对应星POS：tradeNo
     * (必填)
     */
    @NotBlank
    private String orderNo;

    /**
     * 商户号
     * 商户所在国通系统内商户号
     * (必填)
     */
    @NotBlank
    private String custId;

    /**
     * 商户的手机号码
     * (特殊必填)
     */
    private String custLogin;

    /**
     * 查询收银系统推送pos订单时必传
     * 01，枚举：01：服务化查询
     * (特殊必填)
     */
    private String orderType;

    /**
     * 终端号
     * 长度8位数字，由合作方自定义
     * (选填)
     */
    private String driveNo;

    /**
     * 订单交易时间
     * 格式yyyyMMdd
     */
    @NotBlank
    private String orderTime;
}