/**
 * fshows.com
 * Copyright (C) 2013-2024 All Rights Reserved.
 */
package com.fshows.postar.request.trade;

import com.alibaba.fastjson.annotation.JSONField;
import com.fshows.postar.request.PostarBaseReq;
import lombok.Data;

import javax.validation.constraints.NotBlank;

/**
 * @author wangqilei
 * @version PostarCloseOrderReq.java, v 0.1 2024-06-05 6:02 PM wangqilei
 */
@Data
public class PostarCloseOrderReq extends PostarBaseReq {
    private static final long serialVersionUID = -8738286847103073327L;

    /**
     * 商户号
     * 商户所在国通系统内的商户号
     * (必填)
     */
    @NotBlank
    private String custId;

    /**
     * 服务商生成的订单号，合作方订单号，必填
     * (必填)
     */
    @NotBlank
    @JSONField(name = "threeOrderNO")
    private String threeOrderNo;
}