/**
 * fshows.com
 * Copyright (C) 2013-2022 All Rights Reserved.
 */
package com.fshows.postar.request.merchant;


import com.fshows.postar.request.PostarBaseReq;
import lombok.Data;

import javax.validation.constraints.NotBlank;

/**
 * @author zhaoxumin
 * @version PostarAppidConfigReq.java, v 0.1 2024-06-05 19:25:59 zhaoxumin
 */
@Data
public class PostarAppidConfigReq  extends PostarBaseReq {

    private static final long serialVersionUID = -2213838555933212939L;

    /**
     * 商户所在国通系统内商户号
     */
    @NotBlank
    private String custId;

    /**
     * 微信公众号/小程序APPID
     */
    @NotBlank
    private String appid;

    /**
     * APPID密钥
     */
    private String appSecret;

    /**
     * 支付配置类型 01公众号 02小程序
     */
    @NotBlank
    private String payType;

    /**
     * 支付通道. 01银联微信 05银联ATQ微信
     */
    @NotBlank
    private String payWay;

    /**
     * 微信子商户. 查询报备信息接口内'thirdMercid'字段
     */
    @NotBlank
    private String wxSubMercid;

    /**
     * 移动支付appid. 联系对接人员获取
     */
    @NotBlank
    private String agetAppid;
}