/**
 * fshows.com
 * Copyright (C) 2013-2023 All Rights Reserved.
 */
package
        com.fshows.postar.request;

import com.fshows.sdk.core.client.base.definition.IRequestDefinition;
import lombok.Data;

import javax.validation.constraints.NotBlank;

/**
 * 全局参数和业务参数嵌套请求类
 *
 * @author zhaoxumin
 * @version PostarBaseReq.java, v 0.1 2024-06-13 15:25:59 zhaoxumin
 */
@Data
public class PostarBaseReq implements IRequestDefinition {

    private static final long serialVersionUID = 1377643399860970983L;
    /**
     * 商户所在国通系统内610开头机构号（或FWH开头虚拟机构号）
     */
    private String agetId;

    /**
     * 版本号,此版接口固定值：1.0.0
     */
    private String version;

    /**
     * 接口请求时间. 格式yyyyMMddHHmmss
     */
    private String timeStamp;

    /**
     * 签名
     */
    private String sign;
}