package com.fshows.postar.apienum;

import com.fshows.postar.contant.PostarConstant;
import com.fshows.postar.request.merchant.PostarAppidConfigReq;
import com.fshows.postar.request.merchant.PostarWxPayConfigReq;
import com.fshows.postar.response.merchant.PostarAppidConfigRes;
import com.fshows.postar.response.merchant.PostarWxPayConfigRes;
import com.fshows.sdk.core.client.base.definition.IApiDefinition;

/**
 * 国通星驿商户相关API
 *
 * @author zhaoxumin
 * @version PostarMerchantApiEnum.java, v 0.1 2024-06-13 15:25:59 zhaoxumin
 */
public enum PostarMerchantApiEnum implements IApiDefinition {
    WX_PAY_CONFIG(
            "配置微信支付目录",
            "/yyfsevr/addCust/wxPayConfig",
            PostarConstant.DEFAULT_API_VERSION,
            PostarWxPayConfigReq.class,
            PostarWxPayConfigRes.class
    ),
    APPID_CONFIG(
            "微信APPID配置",
            "/yyfsevr/addCust/appidConfig",
            PostarConstant.DEFAULT_API_VERSION,
            PostarAppidConfigReq.class,
            PostarAppidConfigRes.class
    ),
    ;

    /**
     * 接口名称
     */
    private String name;
    /**
     * 接口uri子资源路径
     */
    private String apiSubURI;
    /**
     * 接口版本，默认1.0
     */
    private String version;
    /**
     * 请求业务参数的Class类型
     */
    private Class requestClass;
    /**
     * 响应业务参数的Class类型
     */
    private Class responseClass;


    PostarMerchantApiEnum(String name,
                          String apiSubURI,
                          String version,
                          Class requestClass,
                          Class responseClass) {
        this.name = name;
        this.apiSubURI = apiSubURI;
        this.version = version;
        this.requestClass = requestClass;
        this.responseClass = responseClass;
    }

    @Override
    public String getApiURI() {
        return apiSubURI;
    }


    @Override
    public String getVersion() {
        return version;
    }

    @Override
    public Class getRequestClass() {
        return requestClass;
    }

    @Override
    public Class getResponseClass() {
        return responseClass;
    }
}