package com.fshows.msfpay.request.item;

import lombok.Data;

/**
 * 小微商户参数
 * @author songjian * @version MsfpayMicroMerchantRequest.java, v 0.1 2025-08-06 19:32 songjian
 */
@Data
public class MsfpayMicroMerchantRequest {
    /**
     * 负责人证件类型
     * 必填: 是
     * 长度: 2
     * 说明: 身份证、港澳居民来往内地通行证、台湾居民来往大陆通行证、外国公民护照
     */
    public String responsibleCertType;

    /**
     * 负责人证件号
     * 必填: 是
     * 长度: 22
     */
    public String responsibleId;

    /**
     * 负责人地址
     * 必填: 是
     * 长度: 10-120
     * 说明: 证件类型"身份证"：输入身份证上的地址；证件类型非身份证：输入负责人在大陆地区的联系地址
     */
    public String responsibleAddr;

    /**
     * 负责人证件有效期开始日期
     * 必填: 是
     * 长度: 8
     * 说明: "证件有效期开始日期"小于等于当前入网日期
     */
    public String responsibleIdBegin;

    /**
     * 负责人证件有效期截止日期
     * 必填: 是
     * 长度: 8
     * 说明: 长期: 9999/12/31，"负责人证件有效期截止日期"大于等于当前入网日期；"负责人证件有效期截止日期"大于"受益所有人证件有效期开始日期"
     */
    public String responsibleIdValid;

    /**
     * 负责人职业
     * 必填: 否
     * 长度: 32
     * 说明: 两级类别用
     */
    public String responsibleOccupation;

    /**
     * 负责人工作单位
     * 必填: 否
     * 长度: 100
     */
    public String responsibleCompany;

    /**
     * 负责人经常居住地址
     * 必填: 否
     * 长度: 150
     */
    public String responsibleLiveAddress;

    /**
     * 负责人证件正面照
     * 必填: 是
     * 长度: 128
     */
    public String responsibleIdFrontPhoto;

    /**
     * 负责人证件反面照
     * 必填: 是
     * 长度: 128
     */
    public String responsibleIdBackPhoto;

    /**
     * 门头照
     * 必填: 是
     * 长度: 128
     */
    public String storePhoto;

    /**
     * 内部经营照
     * 必填: 是
     * 长度: 128
     */
    public String storeInsidePhoto;

    /**
     * 商户网站地址
     * 必填: 否
     * 长度: 128
     */
    public String merchantUrl;

    /**
     * 结算银行卡照片
     * 必填: 否
     */
    public String handleBankPhoto;

    /**
     * 租赁协议/产权证明/集中经营场所证明照（影像）
     * 必填: 是
     * 长度: 128
     */
    public String proofPhoto;

    /**
     * 负责人于经营场所手持营业执照/身份证件照片
     * 必填: 是
     * 长度: 128
     */
    public String responsibleHoldingPhoto;

    /**
     * 其他照片
     * 必填: 否
     * 长度: 128
     */
    public String otherPhoto;
}
