package com.fshows.msfpay.request;

import lombok.Data;
import lombok.EqualsAndHashCode;

import javax.validation.constraints.NotBlank;

/**
 * CMS015-微信配置请求
 */
@Data
@EqualsAndHashCode(callSuper = true)
public class MsfpayWechatConfigRequest extends MsfpayBizRequest {

    /**
     * 中投商户号
     * 必填: 是
     * 长度: 12
     */
    @NotBlank(message = "中投商户号不能为空")
    private String merid;

    /**
     * 通道编码
     * 必填: 是
     * 长度: 8
     * 说明: 条码支付开通时返回，取值范围：Qr004、Qr003
     */
    @NotBlank(message = "通道编码不能为空")
    private String chlcode;

    /**
     * 配置类型
     * 必填: 是
     * 长度: 8
     * 说明: appid：公众号或小程序appid配置；path：公众号支付目录配置；recommend：推荐关注配置
     */
    @NotBlank(message = "配置类型不能为空")
    private String cfgtype;

    /**
     * 配置信息
     * 必填: 是
     * 长度: 128
     * 说明: 配置类型为appid时填写appid；配置类型为path时填写支付目录；配置类型为recommend时填写推荐关注的公众号或小程序appid
     */
    @NotBlank(message = "配置信息不能为空")
    private String cfginfo;

    /**
     * 微信银行商户号
     * 必填: 是
     * 长度: 32
     * 说明: 与调用开通条码支付(CMS011)接口时使用的中投微信银行商户号一致
     */
    @NotBlank(message = "微信银行商户号不能为空")
    private String mchid;

    /**
     * 微信子商户号
     * 必填: 否
     * 长度: 32
     * 说明: 条码支付开通(CMS011)接口时,返回的chlmerid字段
     */
    private String chlmerid;

    /**
     * 微信子商户appid
     * 必填: 否
     * 长度: 32
     * 说明: 推荐关注配置时选填
     */
    private String subappid;

    /**
     * 推荐关注类型
     * 必填: 否
     * 长度: 32
     * 说明: 推荐关注配置时必填，mp 公众号，mini 小程序
     */
    private String recommendtype;
}
