package com.fshows.msfpay.apienum;

import com.fshows.msfpay.request.MsfpayAutoSignPythonRequest;
import com.fshows.msfpay.request.MsfpayMerchantSignRequest;
import com.fshows.msfpay.response.MsfpayAutoSignPythonResponse;
import com.fshows.msfpay.response.MsfpayAutoSignResponse;
import com.fshows.sdk.core.client.base.definition.IApiDefinition;
import lombok.Getter;

/**
 * 中投科信支付API定义枚举 - 商户管理类接口 (CMS)
 */
@Getter
public enum MsfpayAutoSignApiDefinitionEnum implements IApiDefinition {

    AUTO_SIGN(
            "自动签约",
            "CMS014",
            "1.0.0",
            "CMS",
            MsfpayMerchantSignRequest.class,
            MsfpayAutoSignResponse.class
    ),
    AUTO_SIGN_PYTHON(
            "自动签约PYTHON",
            "CMS014",
            "1.0.0",
            "CMS",
            MsfpayAutoSignPythonRequest.class,
            MsfpayAutoSignPythonResponse.class
    ),
    ;

    /**
     * 接口名称
     */
    private final String name;

    /**
     * 交易编码
     */
    private final String trancode;

    /**
     * 接口版本
     */
    private final String version;

    /**
     * 接口类型
     */
    private final String interfaceType;

    /**
     * 请求业务参数的Class类型
     */
    private final Class requestClass;

    /**
     * 响应业务参数的Class类型
     */
    private final Class responseClass;

    MsfpayAutoSignApiDefinitionEnum(String name,
                                    String trancode,
                                    String version,
                                    String interfaceType,
                                    Class requestClass,
                                    Class responseClass) {
        this.name = name;
        this.trancode = trancode;
        this.version = version;
        this.interfaceType = interfaceType;
        this.requestClass = requestClass;
        this.responseClass = responseClass;
    }

    @Override
    public String getApiURI() {
        return trancode;
    }

    @Override
    public String getVersion() {
        return version;
    }

    @Override
    public Class getRequestClass() {
        return requestClass;
    }

    @Override
    public Class getResponseClass() {
        return responseClass;
    }
}
