package com.fshows.msfpay.response.item;

import lombok.Data;

/**
 * 商户费率信息项
 */
@Data
public class MsfpayMerRateItemResponse {

    /**
     * 交易代码
     * 必填: 是
     * 长度: 10
     * 示例: CAS010
     */
    private String tranCode;

    /**
     * 银行卡客户类型
     * 必填: 是
     * 长度: 2
     * 示例: 00
     */
    private String bankCardCstType;

    /**
     * 银行卡类型
     * 必填: 是
     * 长度: 2
     * 示例: 01
     */
    private String bankCardType;

    /**
     * 二级收费模式
     * 必填: 是
     * 长度: 2
     * 示例: 1
     */
    private String secChargeMode;

    /**
     * 费率区间列表
     * 必填: 是
     * 长度: 1000
     * 示例: [{"fee":"0.05"}]
     * 对应对象: MsfpayRateSectionItemResponse
     */
    private String section;
} 