package com.fshows.msfpay.response.item;

import lombok.Data;

import java.math.BigDecimal;

/**
 * @author songjian * @version MsfpayCouponInfoResponse.java, v 0.1 2025-08-06 20:07 songjian
 */
@Data
public class MsfpayCouponInfoResponse {
    /**
     * 活动编码
     * 必填: 是
     * 长度: 32
     */
    public String activityCode;

    /**
     * 活动名称
     * 必填: 是
     * 长度: 32
     */
    public String activityName;

    /**
     * 红包编码
     * 必填: 是
     * 长度: 32
     */
    public String couponCode;

    /**
     * 红包面额
     * 必填: 是
     * 类型: NUMBER(16,2)
     */
    public BigDecimal couponAmt;

    /**
     * 已用金额
     * 必填: 是
     * 类型: NUMBER(16,2)
     */
    public BigDecimal usedAmt;

    /**
     * 红包余额
     * 必填: 是
     * 类型: NUMBER(16,2)
     */
    public BigDecimal balanceAmt;

    /**
     * 有效期开始时间
     * 必填: 是
     * 长度: 32
     * 格式: yyyyMMddHHmmss
     */
    public String startTime;

    /**
     * 有效期截止日期
     * 必填: 是
     * 长度: 32
     * 格式: yyyyMMddHHmmss
     */
    public String endTime;

    /**
     * 状态
     * 必填: 是
     * 说明: USABLE:可用,DISABLE:停用,EXPIRED:过期
     */
    public String state;
}
