package com.fshows.msfpay.response.item;

import lombok.Data;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;

/**
 * 红包明细信息响应对象
 * 用于返回红包的详细信息
 */
@Data
public class MsfpayActCouponDetailsResponse {

    /**
     * 活动编码
     * 必填: 是
     * 长度: 32
     * 说明: 关联的活动编码
     */
    private String activityCode;

    /**
     * 红包编码
     * 必填: 是
     * 长度: 32
     * 说明: 红包的唯一标识编码
     */
    private String couponCode;

    /**
     * 红包面额
     * 必填: 是
     * 长度: 16.2
     * 说明: 红包的面额，单位为元
     */
    private BigDecimal couponAmt;

    /**
     * 有效期开始时间
     * 必填: 是
     * 长度: 32
     * 格式: yyyyMMddHHmmss
     * 说明: 红包生效的开始时间
     */
    private String startTime;

    /**
     * 有效期截止日期
     * 必填: 是
     * 长度: 32
     * 格式: yyyyMMddHHmmss
     * 说明: 红包失效的截止时间
     */
    private String endTime;

    /**
     * 状态
     * 必填: 是
     * 说明: 红包的当前状态
     * USABLE: 可用
     * DISABLE: 停用
     * EXPIRED: 过期
     */
    private String state;
}
