package com.fshows.msfpay.response;

import lombok.Data;

import java.math.BigDecimal;

/**
 * CAS054-查询结算明细数据响应
 */
@Data
public class MsfpaySettlementDetailQueryResponse extends MsfpayBizResponse {

    /**
     * 明细总条数
     * 必填: 是
     */
    private Integer totalnum;

    /**
     * 支付订单总笔数
     * 必填: 是
     */
    private Integer paytotalnum;

    /**
     * 支付订单总金额
     * 必填: 是
     * 长度: 16,2
     */
    private BigDecimal paytotalamt;

    /**
     * 支付订单总手续费
     * 必填: 是
     * 长度: 16,2
     */
    private BigDecimal paytotalfee;

    /**
     * 退款订单总笔数
     * 必填: 是
     */
    private Integer refundtotalnum;

    /**
     * 退款订单总金额
     * 必填: 是
     * 长度: 16,2
     */
    private BigDecimal refundtotalamt;

    /**
     * 退款订单总手续费
     * 必填: 是
     * 长度: 16,2
     */
    private BigDecimal refundtotalfee;

    /**
     * 提现总笔数
     * 必填: 是
     * 说明: 额度提现CAS025
     */
    private Integer cashouttotalnum;

    /**
     * 提现总金额
     * 必填: 是
     * 长度: 16,2
     */
    private BigDecimal cashouttotalamt;

    /**
     * 提现总手续费
     * 必填: 是
     * 长度: 16,2
     */
    private BigDecimal cashouttotalfee;

    /**
     * 代付总笔数
     * 必填: 是
     * 说明: 额度代付CAS024
     */
    private Integer agentpaytotalnum;

    /**
     * 代付总金额
     * 必填: 是
     * 长度: 16,2
     */
    private BigDecimal agentpaytotalamt;

    /**
     * 代付总手续费
     * 必填: 是
     * 长度: 16,2
     */
    private BigDecimal agentpaytotalfee;

    /**
     * 调账总笔数
     * 必填: 是
     * 说明: ADJUST
     */
    private Integer adjusttotalnum;

    /**
     * 调账总金额
     * 必填: 是
     * 长度: 16,2
     */
    private BigDecimal adjusttotalamt;

    /**
     * 调账总手续费
     * 必填: 是
     * 长度: 16,2
     */
    private BigDecimal adjusttotalfee;

    /**
     * 冻结总笔数
     * 必填: 是
     * 说明: FREEZE
     */
    private Integer freezetotalnum;

    /**
     * 冻结总金额
     * 必填: 是
     * 长度: 16,2
     */
    private BigDecimal freezetotalamt;

    /**
     * 冻结总手续费
     * 必填: 是
     * 长度: 16,2
     */
    private BigDecimal freezetotalfee;

    /**
     * 解冻总笔数
     * 必填: 是
     * 说明: DEDUCT
     */
    private Integer deducttotalnum;

    /**
     * 解冻总金额
     * 必填: 是
     * 长度: 16,2
     */
    private BigDecimal deducttotalamt;

    /**
     * 解冻总手续费
     * 必填: 是
     * 长度: 16,2
     */
    private BigDecimal deducttotalfee;

    /**
     * 明细数据
     * 必填: 是
     * 说明: gzip文件，base64编码
     */
    private String data;
}
