package com.fshows.msfpay.response;

import lombok.Data;

import java.math.BigDecimal;

/**
 * CAS049-会员分账交易状态查询响应
 */
@Data
public class MsfpayMemberSplitQueryResponse extends MsfpayBizResponse {

    /**
     * 商户编号
     * 必填: 否
     * 长度: 12
     */
    private String merid;

    /**
     * 会员编号
     * 必填: 否
     * 长度: 12
     */
    private String memUserId;

    /**
     * 交易金额
     * 必填: 否
     * 长度: 20
     */
    private BigDecimal tranamt;

    /**
     * 交易状态
     * 必填: 否
     * 长度: 2
     * 说明: 00成功 01失败 02处理中
     */
    private String state;

    /**
     * 到账银行卡号
     * 必填: 否
     * 长度: 32
     */
    private String cardNo;

    /**
     * 原交易返回码
     * 必填: 否
     * 长度: 10
     */
    private String oriRespCode;

    /**
     * 原交易返回信息
     * 必填: 否
     * 长度: 128
     */
    private String oriRespMsg;
}
