/**
 * fshows.com
 * Copyright (C) 2013-2025 All Rights Reserved.
 */
package com.fshows.msfpay.request.item;

import lombok.Data;

/**
 * @author wangyi
 * @version MsfpayTerminalInfoRequest.java, v 0.1 2025-08-11 13:36 wangyi
 */
@Data
public class MsfpayTerminalInfoRequest {

    /**
     * 商户终端识别码
     * 商户侧终端唯一编号。
     */
    private String deviceId;

    /**
     * 受理终端设备实时经纬度信息，格 式为纬度/经度，+表示北纬、东经， -表示南纬、西经。 示例：+37.12/- 121.213 。
     * 注：商户端设备IP二选一。
     */
    private String location;

    /**
     * 	商户端终端设备IP 地址。
     * 注：与经纬度信息二选一。
     */
    private String deviceIp;

    /**
     * 仅在被扫支付类交易报文中出现： 若付款码为 19 位数字，则取后6 位； 若付款码为 EMV 二维码，则取其 tag 57 的卡号/token 号的后 6 位
     */
    private String encryptRandNum;

    /**
     * 仅在被扫支付类交易报文中出现： 64bit 的密文数据，对终端硬件序列 号和加密随机因子加密后的结果。 本子域取值为：64bit 密文数据进行 base64 编码后的结果。
     */
    private String secretText;
}