package com.fshows.msfpay.request.item;

import lombok.Data;

import javax.validation.constraints.NotBlank;

/**
 * 退款明细项
 */
@Data
public class MsfpayRefundItemRequest {

    /**
     * 商户号
     * 必填: 是
     * 长度: 12
     * 示例: CF3000038556
     */
    @NotBlank(message = "商户号不能为空")
    private String merid;

    /**
     * 退款金额
     * 必填: 是
     * 长度: 16,2
     * 示例: 0.01
     * 说明: 以元为单位，保留小数2位
     */
    @NotBlank(message = "退款金额不能为空")
    private String refundamt;

    /**
     * 项目编号
     * 必填: 否
     * 长度: 128
     * 示例: 1000000001
     * 说明: 项目编号，非必输
     */
    private String prno;
} 