package com.fshows.msfpay.request.item;

import lombok.Data;

/**
 * 个人分账会员信息响应类
 * @author songjian * @version MsfpayPersonalRequest.java, v 0.1 2025-08-06 19:42 songjian
 */
@Data
public class MsfpayPersonalRequest {
    /**
     * 签约手机号
     * 必填: 是
     * 长度: 11
     * 说明: 该号码必须为客户实名手机号码
     */
    public String phone;

    /**
     * 会员名称
     * 必填: 是
     * 长度: 64
     */
    public String custname;

    /**
     * 会员类型
     * 必填: 是
     * 长度: 1
     * 说明: 3个人
     */
    public String usertype;

    /**
     * 身份证正面照片
     * 必填: 是
     * 长度: 128
     */
    public String idfrontimgurl;

    /**
     * 身份证反面照片
     * 必填: 是
     * 长度: 128
     */
    public String idbackimgurl;

    /**
     * 证件类型
     * 必填: 是
     * 长度: 64
     * 说明: 0 身份证 5港澳居民来往内地通行证 6台湾同胞来往内地通行证
     */
    public String certtype;

    /**
     * 证件号码
     * 必填: 是
     * 长度: 22
     */
    public String certno;

    /**
     * 证件有效期开始
     * 必填: 是
     * 长度: 8
     * 格式: yyyyMMdd
     */
    public String signdate;

    /**
     * 证件有效期截止
     * 必填: 是
     * 长度: 64
     * 格式: yyyyMMdd
     */
    public String certdate;

    /**
     * 证件地址省编码
     * 必填: 否
     * 长度: 6
     * 说明: 证件类型非身份证时，必填;身份证类型时，根据身份证号识别,无法识别时需填写
     */
    public String procode;

    /**
     * 证件地址市编码
     * 必填: 否
     * 长度: 64
     * 说明: 同证件地址省编码
     */
    public String citycode;

    /**
     * 证件地址区县编码
     * 必填: 否
     * 长度: 64
     * 说明: 同证件地址省编码
     */
    public String regioncode;

    /**
     * 证件地址详细地址
     * 必填: 是
     * 长度: 64
     */
    public String address;

    /**
     * 银行卡类型
     * 必填: 是
     * 长度: 2
     * 说明: 01 借记
     */
    public String bankcardtype;

    /**
     * 银行卡号
     * 必填: 是
     * 长度: 32
     */
    public String bankcardno;

    /**
     * 预留手机号
     * 必填: 是
     * 长度: 11
     */
    public String bankprephone;

    /**
     * 银行卡照片
     * 必填: 是
     * 长度: 128
     */
    public String bankcardimgurl;

    /**
     * 职业
     * 必填: 否
     * 长度: 32
     */
    public String occupation;

    /**
     * 常驻地址省编码
     * 必填: 否
     * 长度: 6
     */
    public String residentPCode;

    /**
     * 常驻地址市编码
     * 必填: 否
     * 长度: 6
     */
    public String residentCCode;

    /**
     * 常驻地址区县编码
     * 必填: 否
     * 长度: 6
     */
    public String residentDCode;

    /**
     * 常驻地址详细地址
     * 必填: 否
     * 长度: 128
     */
    public String residentaddress;

    /**
     * 补充验证银行卡号
     * 必填: 否
     * 长度: 32
     * 说明: 当注册返回"请补一张卡补足验证渠道数量"时，一般为手机号验证不通过，可更换手机号重新注册，或在此字段上送另外一张经营者本人银行卡号
     */
    public String supplementbankcardno;
}
