package com.fshows.msfpay.request.item;

import lombok.Data;

import java.util.List;

/**
 * 商品详情
 * 用于微信单品优惠活动
 * 对应 goodsdetail 参数的JSON结构
 */
@Data
public class MsfpayGoodsDetailRequest {

    /**
     * 订单原价
     * 必填: 是
     * 说明: 1、商户侧一张小票订单可能被分多次支付，订单原价用于记录整张小票的交易金额。
     *      2、当订单原价与支付金额不相等，则不享受优惠。
     *      3、该字段主要用于防止同一张小票分多次支付，以享受多次优惠的情况，正常支付订单不必上传此参数。
     *      单位为分
     */
    private Long costPrice;

    /**
     * 商家小票ID
     * 必填: 是
     * 长度: 32
     * 说明: 商家小票ID
     */
    private String receiptId;

    /**
     * 商品详情列表
     * 必填: 是
     * 说明: 单品优惠功能字段，需要接入单品优惠的商户传入
     */
    private List<MsfpayGoodsDetailItemRequest> goodsDetail;
}
